/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.gui.UIDesign.xmlEditor;

import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.kframework.krun.gui.UIDesign.ConfigurationPanel;
import org.kframework.krun.gui.UIDesign.xmlEditor.TagView;
import org.kframework.krun.gui.UIDesign.xmlEditor.XMLDocument;
import org.kframework.krun.gui.UIDesign.xmlEditor.XMLReader;
import org.kframework.krun.gui.UIDesign.xmlEditor.XMLViewFactory;

public class XMLEditorKit
extends StyledEditorKit {
    private static final long serialVersionUID = 1L;
    static JTextPane confText;
    ViewFactory defaultFactory = new XMLViewFactory();
    MouseListener lstCollapse = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            Shape a;
            int i;
            View v;
            JEditorPane src = (JEditorPane)e.getSource();
            int pos = src.viewToModel(e.getPoint());
            for (v = src.getUI().getRootView(src); v != null && !(v instanceof TagView); v = v.getView(i)) {
                i = v.getViewIndex(pos, Position.Bias.Forward);
            }
            TagView deepest = (TagView)v;
            while (v != null && v instanceof TagView) {
                deepest = (TagView)v;
                int i2 = v.getViewIndex(pos, Position.Bias.Forward);
                v = v.getView(i2);
            }
            if (deepest != null && (a = XMLEditorKit.getAllocation(deepest, src)) != null) {
                Rectangle r = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
                r.y += 5;
                r.width = 10;
                r.height = 10;
                if (r.contains(e.getPoint())) {
                    int tagNo;
                    XMLDocument doc = (XMLDocument)src.getDocument();
                    String[] elements = null;
                    try {
                        String element = doc.getText(deepest.getStartOffset(), deepest.getEndOffset() - deepest.getStartOffset());
                        elements = element.split("\n");
                    }
                    catch (BadLocationException e2) {
                        e2.printStackTrace();
                    }
                    if (deepest.isExpanded()) {
                        deepest.setExpanded(false);
                        tagNo = XMLEditorKit.this.getTagPosition(doc, elements[0], pos);
                        ConfigurationPanel.collapsedViews.put(elements[0] + "|" + tagNo, deepest.getEndOffset() - deepest.getStartOffset());
                    } else {
                        tagNo = XMLEditorKit.this.getTagPosition(doc, (String)elements[0], pos);
                        ConfigurationPanel.collapsedViews.remove(elements[0] + "|" + tagNo);
                        deepest.setExpanded(true);
                    }
                    try {
                        doc.setUserChanges(false);
                        doc.insertString(++pos, "\n", new SimpleAttributeSet());
                        doc.remove(pos, 1);
                        doc.setUserChanges(true);
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    };
    Cursor oldCursor;
    MouseMotionListener lstMoveCollapse = new MouseMotionAdapter(){

        @Override
        public void mouseMoved(MouseEvent e) {
            Shape a;
            int i;
            View v;
            JEditorPane src = (JEditorPane)e.getSource();
            if (XMLEditorKit.this.oldCursor == null) {
                XMLEditorKit.this.oldCursor = src.getCursor();
            }
            int pos = src.viewToModel(e.getPoint());
            for (v = src.getUI().getRootView(src); v != null && !(v instanceof TagView); v = v.getView(i)) {
                i = v.getViewIndex(pos, Position.Bias.Forward);
            }
            TagView deepest = (TagView)v;
            while (v != null && v instanceof TagView) {
                deepest = (TagView)v;
                int i2 = v.getViewIndex(pos, Position.Bias.Forward);
                v = v.getView(i2);
            }
            if (deepest != null && (a = XMLEditorKit.getAllocation(deepest, src)) != null) {
                Rectangle r = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
                r.y += 5;
                r.width = 10;
                r.height = 10;
                if (r.contains(e.getPoint())) {
                    src.setCursor(Cursor.getPredefinedCursor(12));
                    return;
                }
            }
            src.setCursor(XMLEditorKit.this.oldCursor);
        }
    };

    public XMLEditorKit(JTextPane confText) {
        XMLEditorKit.confText = confText;
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.defaultFactory;
    }

    @Override
    public MutableAttributeSet getInputAttributes() {
        MutableAttributeSet mAttrs = super.getInputAttributes();
        return mAttrs;
    }

    @Override
    public Document createDefaultDocument() {
        return new XMLDocument();
    }

    @Override
    public String getContentType() {
        return "text/xml";
    }

    @Override
    public void read(Reader in, Document doc, int pos) throws IOException, BadLocationException {
        BufferedReader br = new BufferedReader(in);
        String firstLine = br.readLine();
        String lastLine = "";
        StringBuffer buff = new StringBuffer();
        String nextLines = firstLine;
        while (nextLines != null) {
            buff.append(nextLines + "\n");
            lastLine = nextLines;
            nextLines = br.readLine();
        }
        if (!this.verifyRootElement(firstLine, lastLine)) {
            buff = this.addRootElement(buff);
        }
        int p = this.getInsertPosition(pos, doc);
        XMLReader.getInstance().read(new ByteArrayInputStream(buff.toString().getBytes()), doc, p);
    }

    @Override
    public void write(OutputStream out, Document doc, int pos, int len) throws IOException, BadLocationException {
        int[] sel = new int[]{pos, pos + len};
        XMLEditorKit.correctSelectionBounds(sel, doc);
        pos = sel[0];
        len = sel[1] - pos;
        super.write(out, doc, pos, len);
    }

    @Override
    public void write(Writer out, Document doc, int pos, int len) throws IOException, BadLocationException {
        int[] sel = new int[]{pos, pos + len};
        XMLEditorKit.correctSelectionBounds(sel, doc);
        pos = sel[0];
        len = sel[1] - pos;
        super.write(out, doc, pos, len);
    }

    public static void correctSelectionBounds(int[] selection, Document d) {
        if (d instanceof XMLDocument && d.getLength() > 0) {
            Element commonParent;
            XMLDocument doc = (XMLDocument)d;
            int start = selection[0];
            Element root = doc.getDefaultRootElement();
            int i = root.getElementIndex(start);
            while (i >= 0 && root.getElement(i).getName().equals(XMLDocument.TAG_ELEMENT)) {
                root = root.getElement(i);
                i = root.getElementIndex(start);
            }
            Element startTag = root;
            int end = selection[0];
            root = doc.getDefaultRootElement();
            i = root.getElementIndex(end);
            while (i >= 0 && root.getElement(i).getName().equals(XMLDocument.TAG_ELEMENT)) {
                root = root.getElement(i);
                i = root.getElementIndex(end);
            }
            Element endTag = root;
            for (commonParent = startTag; commonParent != null && (commonParent.getStartOffset() > endTag.getStartOffset() || commonParent.getEndOffset() < endTag.getEndOffset()); commonParent = commonParent.getParentElement()) {
            }
            if (commonParent != null) {
                selection[0] = commonParent.getStartOffset();
                selection[1] = commonParent.getEndOffset();
            }
        }
    }

    protected int getInsertPosition(int pos, Document d) {
        if (d instanceof XMLDocument && d.getLength() > 0) {
            XMLDocument doc = (XMLDocument)d;
            Element root = doc.getDefaultRootElement();
            int i = root.getElementIndex(pos);
            while (i >= 0 && root.getElement(i).getName().equals(XMLDocument.TAG_ELEMENT)) {
                root = root.getElement(i);
                i = root.getElementIndex(pos);
            }
            while (root.getElementCount() < 3) {
                root = root.getParentElement();
            }
            return root.getElement(0).getEndOffset();
        }
        return pos;
    }

    @Override
    public void install(JEditorPane c) {
        super.install(c);
        c.setEditable(true);
        c.addMouseListener(this.lstCollapse);
        c.addMouseMotionListener(this.lstMoveCollapse);
    }

    @Override
    public void deinstall(JEditorPane c) {
        c.removeMouseListener(this.lstCollapse);
        c.removeMouseMotionListener(this.lstMoveCollapse);
        super.deinstall(c);
    }

    protected static Shape getAllocation(View v, JEditorPane edit) {
        Insets ins = edit.getInsets();
        int x = ins.left;
        int y = ins.top;
        for (View vParent = v.getParent(); vParent != null; vParent = vParent.getParent()) {
            int i = vParent.getViewIndex(v.getStartOffset(), Position.Bias.Forward);
            Shape alloc = vParent.getChildAllocation(i, new Rectangle(0, 0, Short.MAX_VALUE, Short.MAX_VALUE));
            x += alloc.getBounds().x;
            y += alloc.getBounds().y;
        }
        if (v instanceof BoxView) {
            int ind = v.getParent().getViewIndex(v.getStartOffset(), Position.Bias.Forward);
            Rectangle r2 = v.getParent().getChildAllocation(ind, new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE)).getBounds();
            return new Rectangle(x, y, r2.width, r2.height);
        }
        return new Rectangle(x, y, (int)v.getPreferredSpan(0), (int)v.getPreferredSpan(1));
    }

    @Override
    public Action[] getActions() {
        Action[] res = super.getActions();
        for (int i = 0; i < res.length; ++i) {
            if (!(res[i] instanceof DefaultEditorKit.CopyAction)) continue;
            res[i] = new XMLCopyAction();
        }
        return res;
    }

    public static void collapseMemorizedTags() {
        Iterator<String> iter = ConfigurationPanel.collapsedViews.keySet().iterator();
        XMLDocument docu = (XMLDocument)confText.getDocument();
        boolean existingTag = false;
        while (iter.hasNext()) {
            int i;
            View v;
            existingTag = false;
            String collapsedTag = iter.next();
            String[] collapsedTagInfo = collapsedTag.split("[|]");
            String doc = "";
            try {
                doc = docu.getText(0, docu.getLength());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            int pos = 0;
            int end = 0;
            if (collapsedTagInfo[1].equals("1")) {
                pos = doc.indexOf(collapsedTagInfo[0]);
                end = doc.indexOf(collapsedTagInfo[0].charAt(0) + "/" + collapsedTagInfo[0].substring(1));
                existingTag = true;
            } else {
                String[] lines = doc.split(collapsedTagInfo[0]);
                if (lines.length > Integer.parseInt(collapsedTagInfo[1])) {
                    pos = doc.indexOf(lines[Integer.parseInt(collapsedTagInfo[1])]) - collapsedTagInfo[0].length();
                    end = pos + lines[Integer.parseInt(collapsedTagInfo[1])].indexOf(collapsedTagInfo[0].charAt(0) + "/" + collapsedTagInfo[0].substring(1));
                    existingTag = true;
                }
            }
            if (!existingTag) continue;
            for (v = confText.getUI().getRootView(confText); v != null && !(v instanceof TagView); v = v.getView(i)) {
                i = v.getViewIndex(pos, Position.Bias.Forward);
            }
            TagView deepest = (TagView)v;
            while (v != null && v instanceof TagView) {
                deepest = (TagView)v;
                int i2 = v.getViewIndex(pos, Position.Bias.Forward);
                v = v.getView(i2);
            }
            if (deepest == null) continue;
            Rectangle r = new Rectangle();
            r.x = pos++;
            r.y = end;
            r.y += 5;
            r.width = 10;
            r.height = 10;
            deepest.setExpanded(false);
            try {
                docu.setUserChanges(false);
                docu.insertString(pos, "\n", new SimpleAttributeSet());
                docu.remove(pos, 1);
                docu.setUserChanges(true);
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        }
    }

    public int getTagPosition(XMLDocument doc, String separator, int pos) {
        int min = Integer.MAX_VALUE;
        int positionMin = -1;
        try {
            String[] lines = doc.getText(0, doc.getLength()).split(separator);
            if (lines.length > 2) {
                for (int i = 0; i < lines.length; ++i) {
                    if (doc.getText(0, doc.getLength()).indexOf(lines[i]) - pos <= 0 || doc.getText(0, doc.getLength()).indexOf(lines[i]) - pos >= min) continue;
                    min = doc.getText(0, doc.getLength()).indexOf(lines[i]) - pos;
                    positionMin = i;
                }
                return positionMin;
            }
            return 1;
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
            return -1;
        }
    }

    public boolean verifyRootElement(String begin, String end) {
        String validEnd = begin.charAt(0) + "/" + begin.substring(1);
        return validEnd.equals(end);
    }

    public StringBuffer addRootElement(StringBuffer buff) {
        return buff.insert(0, "<configurations>").append("</configurations>");
    }

    public class XMLCopyAction
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public XMLCopyAction() {
            super("copy-to-clipboard");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target != null) {
                int end;
                int start = target.getSelectionStart();
                if (start != (end = target.getSelectionEnd())) {
                    int[] sel = new int[]{start, end};
                    XMLEditorKit.correctSelectionBounds(sel, target.getDocument());
                    target.setSelectionStart(sel[0]);
                    target.setSelectionEnd(sel[1]);
                }
                target.copy();
            }
        }
    }
}

