/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.gui.UIDesign.xmlEditor;

import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.kframework.krun.gui.UIDesign.xmlEditor.TagView;
import org.kframework.krun.gui.UIDesign.xmlEditor.WrapLabelView;
import org.kframework.krun.gui.UIDesign.xmlEditor.XMLDocument;

class XMLViewFactory
implements ViewFactory {
    XMLViewFactory() {
    }

    @Override
    public View create(Element elem) {
        String kind = elem.getName();
        if (kind != null) {
            if (kind.equals("content")) {
                return new WrapLabelView(elem);
            }
            if (kind.equals(XMLDocument.TAG_ELEMENT)) {
                return new TagView(elem);
            }
            if (kind.equals(XMLDocument.TAG_ROW_START_ELEMENT) || kind.equals(XMLDocument.TAG_ROW_END_ELEMENT)) {
                return new BoxView(elem, 0){

                    @Override
                    public float getAlignment(int axis) {
                        return 0.0f;
                    }

                    @Override
                    public float getMaximumSpan(int axis) {
                        return this.getPreferredSpan(axis);
                    }
                };
            }
            if (kind.equals("section")) {
                return new BoxView(elem, 1);
            }
            if (kind.equals("component")) {
                return new ComponentView(elem);
            }
            if (kind.equals("icon")) {
                return new IconView(elem);
            }
        }
        return new LabelView(elem);
    }
}

