/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.gui.diff;

import difflib.Delta;
import difflib.DiffUtils;
import difflib.Patch;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;

public class Diff {
    private static final String STYLESAME = "";
    private static final String YELLLOW = "#FFFF00";
    private static final String ORANGE = "#FFCC00";
    private static final String GREEN = "#00FF00";
    private static final String GRAY = "#E0E0E0";
    private StringBuilder sb = new StringBuilder();

    StringBuilder l2b(List<?> l) {
        this.sb.delete(0, this.sb.length());
        for (Object object : l) {
            this.sb.append(object + "\n");
        }
        if (this.sb.length() >= 1) {
            this.sb.deleteCharAt(this.sb.length() - 1);
        }
        return this.sb;
    }

    public static String comparableTest(String str1, String str2) {
        String[] x = str1.split("\\n");
        String[] y = str2.split("\\n");
        LinkedList<String> original = new LinkedList<String>();
        for (String s : x) {
            original.add(StringEscapeUtils.escapeHtml4(s));
        }
        LinkedList<String> revised = new LinkedList<String>();
        for (String s : y) {
            revised.add(StringEscapeUtils.escapeHtml4(s));
        }
        StringBuilder tl = new StringBuilder();
        StringBuilder tr = new StringBuilder();
        StringBuilder fin = new StringBuilder();
        Patch patch = DiffUtils.diff(original, revised);
        List<Delta> deltas = patch.getDeltas();
        Diff l2B = new Diff();
        int last = 0;
        for (Delta delta : deltas) {
            String colorRev;
            int i;
            int lines;
            String colorOrg;
            tl.delete(0, tl.length());
            tr.delete(0, tr.length());
            if (last + 1 < delta.getOriginal().getPosition()) {
                tl.append("<td style=''>\n");
                tr.append("<td style=''>\n");
                for (int i2 = last + 1; i2 < delta.getOriginal().getPosition(); ++i2) {
                    tl.append((String)original.get(i2) + "\n");
                    tr.append((String)original.get(i2) + "\n");
                }
                tl.append("</td>\n");
                tr.append("</td>\n");
                fin.append("<tr>" + tl + tr + "</tr>");
            }
            List<?> or = delta.getOriginal().getLines();
            List<?> re = delta.getRevised().getLines();
            String org = l2B.l2b(or).toString();
            String rev = l2B.l2b(re).toString();
            boolean deleted = false;
            if (org.trim().isEmpty()) {
                colorOrg = GRAY;
                lines = rev.split("\n").length;
                for (i = 0; i < lines; ++i) {
                    org = org + "\n";
                }
                colorRev = GREEN;
            } else if (rev.trim().isEmpty()) {
                colorRev = GRAY;
                lines = org.split("\n").length;
                for (i = 1; i < lines; ++i) {
                    rev = rev + "\n";
                }
                deleted = true;
                colorOrg = ORANGE;
            } else {
                colorRev = YELLLOW;
                colorOrg = YELLLOW;
            }
            tl.delete(0, tl.length());
            tr.delete(0, tr.length());
            tl.append("<td style='background-color:" + colorOrg + ";'>" + (deleted ? "<del>" : STYLESAME) + org.replaceAll("\\n", "<br>") + "<br>" + (deleted ? "</del>" : STYLESAME) + "</td>");
            tr.append("<td style='background-color:" + colorRev + ";'>" + rev.replaceAll("\\n", "<br>") + "<br></td>");
            fin.append("<tr>" + tl + tr + "</tr>");
            last = delta.getOriginal().last();
        }
        if (last + 1 < original.size()) {
            tl.delete(0, tl.length());
            tr.delete(0, tr.length());
            tl.append("<td style=''>\n");
            tr.append("<td style=''>\n");
            for (int i = last + 1; i < original.size(); ++i) {
                tl.append((String)original.get(i) + "\n");
                tr.append((String)original.get(i) + "\n");
            }
            tl.append("</td>\n");
            tr.append("</td>\n");
            fin.append("<tr>" + tl + tr + "</tr>");
        }
        return "<html><table>" + fin + "</table></html>";
    }
}

