/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.gui.helper;

import java.io.File;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.kframework.krun.gui.helper.HelpInfo;
import org.kframework.krun.gui.helper.TreeNode;
import org.kframework.utils.file.KPaths;

public class TreeFromFile {
    public DefaultMutableTreeNode top;
    public JTree tree;
    private String SUBSUBSECTION_DELIMITER = "\\\\subsubsection";
    private String PARAGRAPH_DELIMITER = "\\\\paragraph";
    private String LABEL_DELIMITER = "\\\\label";
    private String GRAPHIC_DEBUGGER_IDENTIFIER = "Debugging programs graphically";
    private String[] latexTerms = new String[]{"\\\\verb", "\\\\texttt", "\\\\label", "^\\{[A-Za-z-:_ ]*\\}", "[^\\\\ref]\\{[A-Za-z-: ]*\\}"};

    public TreeFromFile() {
        this.top = new DefaultMutableTreeNode(new TreeNode("Graphical debugger"));
        this.readFile();
        this.tree = new JTree(this.top);
        this.tree.getSelectionModel().setSelectionMode(1);
    }

    public void readFile() {
        this.getParagraphs(this.getManualContentforGraphDebugger(this.buildPathToFile()));
    }

    public String buildPathToFile() {
        return KPaths.getKBase(false) + System.getProperty("file.separator") + "documentation" + System.getProperty("file.separator") + "ref-manual.k";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getManualContentforGraphDebugger(String filePath) {
        try (Scanner scanner = null;){
            scanner = new Scanner(new File(filePath));
            scanner.useDelimiter(this.SUBSUBSECTION_DELIMITER);
            while (scanner.hasNext()) {
                String currentSection = scanner.next();
                if (!currentSection.contains(this.GRAPHIC_DEBUGGER_IDENTIFIER)) continue;
                String string = currentSection;
                return string;
            }
        }
        return "";
    }

    public void setTopContent(String content) {
        ((TreeNode)this.top.getUserObject()).setContent(this.replaceLatexTerms(content, this.top.getUserObject().toString()));
    }

    public void getParagraphs(String content) {
        String[] paragraphs = content.split(this.PARAGRAPH_DELIMITER);
        this.setTopContent(paragraphs[0]);
        for (int i = 1; i < paragraphs.length; ++i) {
            if (!this.verifyChildren(paragraphs[i])) {
                String nodeName = this.getPrintableName(paragraphs[i].split("\n")[0]);
                DefaultMutableTreeNode paragraph = new DefaultMutableTreeNode(new TreeNode(nodeName, this.replaceLatexTerms(paragraphs[i], nodeName)));
                this.top.add(paragraph);
                continue;
            }
            DefaultMutableTreeNode paragraph = new DefaultMutableTreeNode(new TreeNode(this.getPrintableName(paragraphs[i].split("\n")[0])));
            this.top.add(paragraph);
            this.getSubParagraphs(paragraphs[i], paragraph);
        }
    }

    public String getPrintableName(String paragraph) {
        return paragraph.replaceAll("[{}]", "");
    }

    public String replaceLatexTerms(String content, String parentName) {
        for (int i = 0; i < this.latexTerms.length; ++i) {
            content = content.replaceAll(this.latexTerms[i], "");
        }
        return this.preserveSpacing(this.setLinks(content), parentName);
    }

    public String setLinks(String content) {
        Pattern p = Pattern.compile("\\\\ref\\{sec:[A-za-z]*\\}");
        Matcher m = p.matcher(content);
        while (m.find()) {
            String result = m.group().toString();
        }
        content = content.replaceAll("\\\\tab", "&nbsp&nbsp&nbsp&nbsp ");
        content = content.replaceAll("\\\\ref\\{sec:", "<a href=\"\">");
        content = content.replaceAll("\\}", "</a>");
        content = content.replaceAll("[{}\\\\^\\\\*/@]", "");
        return content;
    }

    public String preserveSpacing(String content, String parentName) {
        content = content.replaceAll("\\n\\n", "<br><br>");
        content = content.replaceAll("\\.\\n", ".<br>");
        return HelpInfo.htmlPrefix + parentName + HelpInfo.htmlMiddle + content + HelpInfo.htmlEnd;
    }

    public void getSubParagraphs(String paragraph, DefaultMutableTreeNode parent) {
        String[] subparagraphs = paragraph.split(this.LABEL_DELIMITER);
        ((TreeNode)parent.getUserObject()).setContent(this.replaceLatexTerms(subparagraphs[1], parent.getUserObject().toString()));
        for (int i = 2; i < subparagraphs.length; ++i) {
            String nodeName = this.getPrintableName(subparagraphs[i].split("\n")[0]);
            DefaultMutableTreeNode subparagraph = new DefaultMutableTreeNode(new TreeNode(nodeName, this.replaceLatexTerms(subparagraphs[i], nodeName)));
            parent.add(subparagraph);
        }
    }

    public boolean verifyChildren(String paragraph) {
        return paragraph.split(this.LABEL_DELIMITER).length > 2;
    }
}

