/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.ioserver.commands;

import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.logging.Logger;
import org.kframework.krun.api.io.FileSystem;
import org.kframework.krun.ioserver.main.IOServer;

public abstract class Command
implements Runnable {
    Socket socket;
    public int maudeId;
    protected FileSystem fs;
    private Logger _logger;

    public Command(String[] args, Socket socket, Logger logger, FileSystem fs) {
        this.socket = socket;
        this.fs = fs;
        this._logger = logger;
    }

    public void fail(String reason) {
        this._logger.info(this.maudeId + " is failing because of " + reason);
        IOServer.fail(Integer.toString(this.maudeId), reason, this.socket);
    }

    public void succeed(String ... messages) {
        if (messages.length == 0) {
            messages = new String[]{"success"};
        }
        String success = this.maudeId + "\u0001" + "success\u0001";
        for (String s : messages) {
            success = success + s + "\u0001";
        }
        this._logger.info("sending '" + success + "\u0001\u0001' to " + this.maudeId);
        success = success + "\u0001\u0001\n";
        BufferedWriter output = null;
        try {
            output = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
            output.write(success);
            output.flush();
            output.close();
        }
        catch (Exception e) {
            this._logger.info("failed to respond to client " + this.maudeId);
            e.printStackTrace();
        }
        try {
            this._logger.info("Closing client socket for " + this.maudeId);
            Thread.sleep(100L);
            this.socket.close();
        }
        catch (Exception e) {
            this._logger.info("failed to close socket for " + this.maudeId);
            e.printStackTrace();
        }
    }
}

