/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.ioserver.commands;

import java.io.IOException;
import java.net.Socket;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.kframework.krun.api.io.FileSystem;
import org.kframework.krun.ioserver.commands.Command;

public class CommandOpendir
extends Command {
    private String path;

    public CommandOpendir(String[] args, Socket socket, Logger logger, FileSystem fs) {
        super(args, socket, logger, fs);
        this.path = args[1];
    }

    @Override
    public void run() {
        try {
            Path dir = Paths.get(this.path, new String[0]);
            DirectoryStream<Path> files = Files.newDirectoryStream(dir);
            ArrayList<String> paths = new ArrayList<String>();
            for (Path file : files) {
                Path relative = dir.relativize(file);
                paths.add(relative.toString());
            }
            String[] result = paths.toArray(new String[0]);
            this.succeed(result);
        }
        catch (NoSuchFileException e) {
            this.fail("ENOENT");
        }
        catch (AccessDeniedException e) {
            this.fail("EACCES");
        }
        catch (NotDirectoryException e) {
            this.fail("ENOTDIR");
        }
        catch (IOException e) {
            this.fail(e.getMessage());
        }
    }
}

