/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.ioserver.commands;

import java.io.IOException;
import java.net.Socket;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import java.util.logging.Logger;
import org.kframework.krun.api.io.FileSystem;
import org.kframework.krun.ioserver.commands.Command;

public class CommandStat
extends Command {
    private String path;
    private boolean follow;

    public CommandStat(String[] args, Socket socket, Logger logger, FileSystem fs) {
        super(args, socket, logger, fs);
        this.path = args[1];
        this.follow = Boolean.parseBoolean(args[2]);
    }

    @Override
    public void run() {
        try {
            PosixFileAttributes attrs = this.follow ? Files.readAttributes(Paths.get(this.path, new String[0]), PosixFileAttributes.class, new LinkOption[0]) : Files.readAttributes(Paths.get(this.path, new String[0]), PosixFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            this.succeed(Long.toString(attrs.lastModifiedTime().toMillis()), Long.toString(attrs.lastAccessTime().toMillis()), Long.toString(attrs.creationTime().toMillis()), Boolean.toString(attrs.isRegularFile()), Boolean.toString(attrs.isDirectory()), Boolean.toString(attrs.isSymbolicLink()), Long.toString(attrs.size()), this.getDevice(attrs.fileKey()), this.getInode(attrs.fileKey()), Integer.toString(attrs.group().hashCode()), Integer.toString(attrs.owner().hashCode()), this.getPermissions(attrs.permissions()));
        }
        catch (NoSuchFileException e) {
            this.fail("ENOENT");
        }
        catch (AccessDeniedException e) {
            this.fail("EACCES");
        }
        catch (FileSystemException e) {
            if (e.getReason() != null && e.getReason().equals("Not a directory")) {
                this.fail("ENOTDIR");
            } else if (e.getReason() != null && e.getReason().equals("Too many levels of symbolic links")) {
                this.fail("ELOOP");
            } else if (e.getReason() != null && e.getReason().equals("File name too long")) {
                this.fail("ENAMETOOLONG");
            } else {
                e.printStackTrace();
                this.fail(e.getMessage());
            }
        }
        catch (IOException e) {
            this.fail(e.getMessage());
        }
    }

    public String getPermissions(Set<PosixFilePermission> permissions) {
        int bits = 0;
        if (permissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
            bits |= 1;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
            bits |= 2;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_READ)) {
            bits |= 4;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
            bits |= 8;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_WRITE)) {
            bits |= 0x10;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_READ)) {
            bits |= 0x20;
        }
        if (permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
            bits |= 0x40;
        }
        if (permissions.contains((Object)PosixFilePermission.OWNER_WRITE)) {
            bits |= 0x80;
        }
        if (permissions.contains((Object)PosixFilePermission.OWNER_READ)) {
            bits |= 0x100;
        }
        return Integer.toString(bits);
    }

    public String getDevice(Object fileKey) {
        String s = fileKey.toString();
        String dev = s.substring(5, s.indexOf(","));
        return Integer.toString(Integer.parseInt(dev, 16));
    }

    public String getInode(Object fileKey) {
        String s = fileKey.toString();
        String ino = s.substring(s.indexOf("ino=") + 4, s.indexOf(")"));
        return ino;
    }
}

