/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.ioserver.filesystem.portable;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import org.kframework.krun.ioserver.filesystem.portable.File;
import org.kframework.krun.ioserver.filesystem.portable.PortableFileSystem;

public class InputStreamFile
extends File {
    protected FileInputStream is;

    public InputStreamFile(FileInputStream is2) {
        this.is = is2;
    }

    @Override
    public long tell() throws IOException {
        try {
            return this.is.getChannel().position();
        }
        catch (IOException e) {
            PortableFileSystem.processIOException(e);
            throw e;
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        try {
            this.is.getChannel().position(pos);
        }
        catch (IOException e) {
            PortableFileSystem.processIOException(e);
            throw e;
        }
    }

    @Override
    public void putc(byte b) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte getc() throws IOException {
        int read;
        try {
            read = this.is.read();
        }
        catch (IOException e) {
            PortableFileSystem.processIOException(e);
            throw e;
        }
        if (read == -1) {
            throw new IOException("EOF");
        }
        return (byte)read;
    }

    @Override
    public byte[] read(int n) throws IOException {
        int read;
        byte[] bytes;
        try {
            bytes = new byte[n];
            read = this.is.read(bytes);
        }
        catch (IOException e) {
            PortableFileSystem.processIOException(e);
            throw e;
        }
        if (read == -1) {
            throw new IOException("EOF");
        }
        return Arrays.copyOfRange(bytes, 0, read);
    }

    @Override
    public void write(byte[] b) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    void close() throws IOException {
        try {
            this.is.close();
        }
        catch (IOException e) {
            PortableFileSystem.processIOException(e);
        }
    }
}

