/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.ioserver.filesystem.portable;

import java.io.FileOutputStream;
import java.io.IOException;
import org.kframework.krun.ioserver.filesystem.portable.File;
import org.kframework.krun.ioserver.filesystem.portable.PortableFileSystem;

public class OutputStreamFile
extends File {
    protected FileOutputStream os;

    public OutputStreamFile(FileOutputStream os) {
        this.os = os;
    }

    @Override
    public long tell() throws IOException {
        try {
            return this.os.getChannel().position();
        }
        catch (IOException e) {
            PortableFileSystem.processIOException(e);
            throw e;
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        try {
            this.os.getChannel().position(pos);
        }
        catch (IOException e) {
            PortableFileSystem.processIOException(e);
            throw e;
        }
    }

    @Override
    public void putc(byte b) throws IOException {
        try {
            this.os.write(b);
        }
        catch (IOException e) {
            PortableFileSystem.processIOException(e);
        }
    }

    @Override
    public byte getc() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] read(int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.os.write(b);
        }
        catch (IOException e) {
            PortableFileSystem.processIOException(e);
        }
    }

    @Override
    void close() throws IOException {
        try {
            this.os.close();
        }
        catch (IOException e) {
            PortableFileSystem.processIOException(e);
        }
    }
}

