/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.ioserver.filesystem.portable;

import java.io.Closeable;
import java.io.EOFException;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections15.BidiMap;
import org.apache.commons.collections15.bidimap.DualHashBidiMap;
import org.kframework.krun.api.io.FileSystem;
import org.kframework.krun.ioserver.filesystem.portable.File;
import org.kframework.krun.ioserver.filesystem.portable.InputStreamFile;
import org.kframework.krun.ioserver.filesystem.portable.OutputStreamFile;
import org.kframework.krun.ioserver.filesystem.portable.RandomAccessFileFile;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class PortableFileSystem
implements FileSystem {
    private BidiMap<Long, FileDescriptor> descriptors = new DualHashBidiMap<Long, FileDescriptor>();
    private Map<FileDescriptor, org.kframework.krun.api.io.File> files = new HashMap<FileDescriptor, org.kframework.krun.api.io.File>();
    private long fdCounter = 3L;

    public PortableFileSystem() {
        this.descriptors.put(0L, FileDescriptor.in);
        this.descriptors.put(1L, FileDescriptor.out);
        this.descriptors.put(2L, FileDescriptor.err);
        this.files.put(FileDescriptor.in, new InputStreamFile(new FileInputStream(FileDescriptor.in)));
        this.files.put(FileDescriptor.out, new OutputStreamFile(new FileOutputStream(FileDescriptor.out)));
        this.files.put(FileDescriptor.err, new OutputStreamFile(new FileOutputStream(FileDescriptor.err)));
    }

    @Override
    public org.kframework.krun.api.io.File get(long fd) throws IOException {
        FileDescriptor fdObj = (FileDescriptor)this.descriptors.get(fd);
        if (fdObj == null) {
            throw new IOException("EBADF");
        }
        org.kframework.krun.api.io.File f = this.files.get(fdObj);
        if (f == null) {
            throw new IOException("EBADF");
        }
        return f;
    }

    @Override
    public long open(String path, String mode) throws IOException {
        if (!("r".equals(mode) || "w".equals(mode) || "rw".equals(mode))) {
            throw new IllegalArgumentException();
        }
        try {
            File file;
            FileDescriptor fileFD;
            Closeable f;
            if (mode.equals("w")) {
                f = new FileOutputStream(path);
                fileFD = ((FileOutputStream)f).getFD();
                file = new OutputStreamFile((FileOutputStream)f);
            } else {
                f = new RandomAccessFile(path, mode);
                fileFD = ((RandomAccessFile)f).getFD();
                file = new RandomAccessFileFile((RandomAccessFile)f);
            }
            long fd = this.fdCounter++;
            this.descriptors.put(fd, fileFD);
            this.files.put(fileFD, file);
            return fd;
        }
        catch (FileNotFoundException e) {
            try {
                PortableFileSystem.processFileNotFoundException(e);
            }
            catch (IOException ioe) {
                if (ioe.getMessage().equals("EISDIR") && mode.equals("r")) {
                    throw new UnsupportedOperationException();
                }
                throw ioe;
            }
            throw e;
        }
    }

    @Override
    public void close(long fd) throws IOException {
        org.kframework.krun.api.io.File f = this.get(fd);
        assert (f instanceof File);
        ((File)f).close();
        this.files.remove(this.descriptors.get(fd));
        this.descriptors.remove(fd);
    }

    static void processFileNotFoundException(FileNotFoundException e) throws IOException {
        String message = e.getMessage();
        int startIdx = message.lastIndexOf("(") + 1;
        int endIdx = message.length() - 1;
        String realMessage = message.substring(startIdx, endIdx);
        PortableFileSystem.processErrno(realMessage, e);
    }

    static void processErrno(String realMessage, IOException e) throws IOException {
        if (realMessage.equals("Permission denied")) {
            throw new IOException("EACCES");
        }
        if (realMessage.equals("Is a directory")) {
            throw new IOException("EISDIR");
        }
        if (realMessage.equals("Too many levels of symbolic links")) {
            throw new IOException("ELOOP");
        }
        if (realMessage.equals("File name too long")) {
            throw new IOException("ENAMETOOLONG");
        }
        if (realMessage.equals("No such file or directory")) {
            throw new IOException("ENOENT");
        }
        if (realMessage.equals("Not a directory")) {
            throw new IOException("ENOTDIR");
        }
        if (realMessage.equals("Negative seek offset")) {
            throw new IOException("EINVAL");
        }
        if (realMessage.equals("Invalid argument")) {
            throw new IOException("EINVAL");
        }
        if (realMessage.equals("Bad file descriptor")) {
            throw new IOException("EBADF");
        }
        if (realMessage.equals("Illegal seek")) {
            throw new IOException("ESPIPE");
        }
        e.printStackTrace();
        GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Unrecognized OS errno. Please file an issue on the K framework issue tracker\nexplaining precisely what you were trying to do and include the above stack trace"));
    }

    static void processIOException(IOException e) throws IOException {
        if (e instanceof EOFException) {
            throw new IOException("EOF");
        }
        PortableFileSystem.processErrno(e.getMessage(), e);
    }
}

