/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.ioserver.filesystem.portable;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import org.kframework.krun.ioserver.filesystem.portable.File;
import org.kframework.krun.ioserver.filesystem.portable.PortableFileSystem;

public class RandomAccessFileFile
extends File {
    protected RandomAccessFile raf;

    public RandomAccessFileFile(RandomAccessFile raf) {
        this.raf = raf;
    }

    @Override
    public long tell() throws IOException {
        try {
            return this.raf.getFilePointer();
        }
        catch (IOException e) {
            PortableFileSystem.processIOException(e);
            throw e;
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        try {
            this.raf.seek(pos);
        }
        catch (IOException e) {
            PortableFileSystem.processIOException(e);
        }
    }

    @Override
    public void putc(byte b) throws IOException {
        try {
            this.raf.writeByte(b);
        }
        catch (IOException e) {
            PortableFileSystem.processIOException(e);
        }
    }

    @Override
    public byte getc() throws IOException {
        try {
            return this.raf.readByte();
        }
        catch (IOException e) {
            PortableFileSystem.processIOException(e);
            throw e;
        }
    }

    @Override
    public byte[] read(int n) throws IOException {
        int read;
        byte[] bytes;
        try {
            bytes = new byte[n];
            read = this.raf.read(bytes);
        }
        catch (IOException e) {
            PortableFileSystem.processIOException(e);
            throw e;
        }
        if (read == -1) {
            throw new IOException("EOF");
        }
        return Arrays.copyOfRange(bytes, 0, read);
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.raf.write(b);
        }
        catch (IOException e) {
            PortableFileSystem.processIOException(e);
        }
    }

    @Override
    void close() throws IOException {
        try {
            this.raf.close();
        }
        catch (IOException e) {
            PortableFileSystem.processIOException(e);
        }
    }
}

