/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.ioserver.jfkbits;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.kframework.krun.ioserver.jfkbits.Atom;
import org.kframework.krun.ioserver.jfkbits.LispParser;

public class ExprList
extends ArrayList<LispParser.Expr>
implements LispParser.Expr {
    String kif = "";
    private static final long serialVersionUID = 1L;
    ExprList parent = null;
    int indent = 1;

    public int getIndent() {
        if (this.parent != null) {
            return this.parent.getIndent() + this.indent;
        }
        return 0;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public void setParent(ExprList parent) {
        this.parent = parent;
    }

    @Override
    public String toString() {
        String indent = "";
        if (this.parent != null && this.parent.get(0) != this) {
            indent = "\n";
            char[] chars = new char[this.getIndent()];
            Arrays.fill(chars, ' ');
            indent = indent + new String(chars);
        }
        String output = indent + "(";
        Iterator it = this.iterator();
        while (it.hasNext()) {
            LispParser.Expr expr = (LispParser.Expr)it.next();
            output = output + expr.toString();
            if (!it.hasNext()) continue;
            output = output + " ";
        }
        output = output + ")";
        return output;
    }

    @Override
    public synchronized boolean add(LispParser.Expr e) {
        if (e instanceof ExprList) {
            ((ExprList)e).setParent(this);
            if (this.size() != 0 && this.get(0) instanceof Atom) {
                ((ExprList)e).setIndent(2);
            }
        }
        return super.add(e);
    }

    @Override
    public String getKIF() {
        String internal = "";
        Iterator it = this.iterator();
        while (it.hasNext()) {
            LispParser.Expr expr = (LispParser.Expr)it.next();
            if (expr.toString().equals("define-fun")) {
                internal = internal + ((LispParser.Expr)it.next()).toString().trim() + "#";
                it.next();
                internal = internal + ((LispParser.Expr)it.next()).toString().trim() + "#";
                internal = internal + ((LispParser.Expr)it.next()).toString().trim().replaceAll("[\\(\\)\\s+]*", "") + "$";
            }
            internal = internal + expr.getKIF() + "##";
        }
        return internal.replaceAll("#+", "#").replaceAll("\\\\s+", "");
    }
}

