/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.ioserver.jfkbits;

import org.kframework.krun.ioserver.jfkbits.Atom;
import org.kframework.krun.ioserver.jfkbits.ExprList;
import org.kframework.krun.ioserver.jfkbits.LispTokenizer;
import org.kframework.krun.ioserver.jfkbits.StringAtom;
import org.kframework.krun.ioserver.jfkbits.Token;

public class LispParser {
    LispTokenizer tokenizer;

    public LispParser(LispTokenizer input) {
        this.tokenizer = input;
    }

    public Expr parseExpr() throws ParseException {
        Token token = this.tokenizer.next();
        switch (token.type) {
            case 40: {
                return this.parseExprList(token);
            }
            case 34: {
                return new StringAtom(token.text);
            }
        }
        return new Atom(token.text);
    }

    protected ExprList parseExprList(Token openParen) throws ParseException {
        ExprList acc = new ExprList();
        while (this.tokenizer.peekToken().type != 41) {
            Expr element = this.parseExpr();
            acc.add(element);
        }
        Token closeParen = this.tokenizer.next();
        return acc;
    }

    public static interface Expr {
        public String getKIF();
    }

    public class ParseException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

