/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.ioserver.jfkbits;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Iterator;
import org.kframework.krun.ioserver.jfkbits.Token;

public class LispTokenizer
implements Iterator<Token> {
    StreamTokenizer m_tokenizer;
    IOException m_ioexn;

    public LispTokenizer(String src) {
        this(new StringReader(src));
    }

    public LispTokenizer(Reader r) {
        if (r == null) {
            r = new StringReader("");
        }
        BufferedReader buffrdr = new BufferedReader(r);
        this.m_tokenizer = new StreamTokenizer(buffrdr);
        this.m_tokenizer.resetSyntax();
        this.m_tokenizer.whitespaceChars(0, 32);
        this.m_tokenizer.wordChars(33, 255);
        this.m_tokenizer.ordinaryChar(40);
        this.m_tokenizer.ordinaryChar(41);
        this.m_tokenizer.ordinaryChar(39);
        this.m_tokenizer.commentChar(59);
        this.m_tokenizer.quoteChar(34);
    }

    public Token peekToken() {
        if (this.m_ioexn != null) {
            return null;
        }
        try {
            this.m_tokenizer.nextToken();
        }
        catch (IOException e) {
            this.m_ioexn = e;
            return null;
        }
        if (this.m_tokenizer.ttype == -1) {
            return null;
        }
        Token token = new Token(this.m_tokenizer);
        this.m_tokenizer.pushBack();
        return token;
    }

    @Override
    public boolean hasNext() {
        if (this.m_ioexn != null) {
            return false;
        }
        try {
            this.m_tokenizer.nextToken();
        }
        catch (IOException e) {
            this.m_ioexn = e;
            return false;
        }
        if (this.m_tokenizer.ttype == -1) {
            return false;
        }
        this.m_tokenizer.pushBack();
        return true;
    }

    public IOException getIOException() {
        return this.m_ioexn;
    }

    @Override
    public Token next() {
        try {
            this.m_tokenizer.nextToken();
        }
        catch (IOException e) {
            this.m_ioexn = e;
            return null;
        }
        Token token = new Token(this.m_tokenizer);
        return token;
    }

    @Override
    public void remove() {
    }
}

