/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.ioserver.main;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Logger;
import org.kframework.kil.loader.Context;
import org.kframework.krun.api.io.FileSystem;
import org.kframework.krun.ioserver.commands.Command;
import org.kframework.krun.ioserver.commands.CommandClose;
import org.kframework.krun.ioserver.commands.CommandEnd;
import org.kframework.krun.ioserver.commands.CommandOpen;
import org.kframework.krun.ioserver.commands.CommandParse;
import org.kframework.krun.ioserver.commands.CommandPosition;
import org.kframework.krun.ioserver.commands.CommandReadbyte;
import org.kframework.krun.ioserver.commands.CommandReadbytes;
import org.kframework.krun.ioserver.commands.CommandSeek;
import org.kframework.krun.ioserver.commands.CommandUnknown;
import org.kframework.krun.ioserver.commands.CommandWritebyte;
import org.kframework.krun.ioserver.commands.CommandWritebytes;

public class IOServer {
    int port;
    ServerSocket serverSocket;
    ThreadPoolExecutor pool;
    private int POOL_THREADS_SIZE = 10;
    private Logger _logger;
    protected Context context;
    protected FileSystem fs;

    public IOServer(int port, Logger logger, Context context, FileSystem fs) {
        this.context = context;
        this.fs = fs;
        this.port = port;
        this._logger = logger;
        this.pool = (ThreadPoolExecutor)Executors.newFixedThreadPool(this.POOL_THREADS_SIZE);
        this.createServer();
    }

    public void createServer() {
        try {
            this.serverSocket = new ServerSocket(this.port);
            this.port = this.serverSocket.getLocalPort();
        }
        catch (IOException e) {
            this._logger.severe("Could not listen on port: " + this.port);
            this._logger.severe("This program will exit with error code: 1");
            System.exit(1);
        }
    }

    public void acceptConnections() throws IOException {
        this._logger.info("Server started at " + this.serverSocket.getInetAddress() + ": " + this.port);
        while (true) {
            Socket clientSocket = this.serverSocket.accept();
            this._logger.info(clientSocket.toString());
            String msg = this.getMessage(clientSocket);
            Command command = this.parseCommand(msg, clientSocket);
            if (command == null) continue;
            this.pool.execute(command);
        }
    }

    private String getMessage(Socket clientSocket) throws IOException {
        StringWriter writer = new StringWriter();
        BufferedReader reader = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
        int n = 0;
        while (n < 2) {
            int c = reader.read();
            writer.write(c);
            if (c != 1) continue;
            ++n;
        }
        String inputLine = writer.toString();
        int length = Integer.parseInt(inputLine.split("\u0001")[1]);
        char[] buffer = new char[length];
        int numRead = reader.read(buffer, 0, length);
        writer.write(buffer, 0, numRead);
        inputLine = writer.toString();
        if (inputLine == null) {
            throw new IOException("Tried to read a line, but was already at EOF");
        }
        return inputLine;
    }

    private Command parseCommand(String msg, Socket clientSocket) {
        String inputLine = msg;
        this._logger.info("received request: " + inputLine);
        String[] args = inputLine.split("\u0001", -1);
        String[] args1 = new String[args.length];
        System.arraycopy(args, 2, args1, 0, args.length - 2);
        Command command = this.createCommand(args1, clientSocket, this._logger);
        command.maudeId = Integer.parseInt(args[0]);
        return command;
    }

    public Command createCommand(String[] args, Socket socket, Logger logger) {
        String command = null;
        if (args.length >= 1) {
            command = args[0];
        } else {
            IOServer.fail("Empty command", socket);
        }
        if (command.equals("open")) {
            return new CommandOpen(args, socket, logger, this.fs);
        }
        if (command.equals("close")) {
            return new CommandClose(args, socket, logger, this.fs);
        }
        if (command.equals("seek")) {
            return new CommandSeek(args, socket, logger, this.fs);
        }
        if (command.equals("position")) {
            return new CommandPosition(args, socket, logger, this.fs);
        }
        if (command.equals("readbyte")) {
            return new CommandReadbyte(args, socket, logger, this.fs);
        }
        if (command.equals("readbytes")) {
            return new CommandReadbytes(args, socket, logger, this.fs);
        }
        if (command.equals("writebyte")) {
            return new CommandWritebyte(args, socket, logger, this.fs);
        }
        if (command.equals("writebytes")) {
            return new CommandWritebytes(args, socket, logger, this.fs);
        }
        if (command.equals("stat") || command.equals("opendir")) {
            String cls = command.equals("stat") ? "org.kframework.krun.ioserver.commands.CommandStat" : "org.kframework.krun.ioserver.commands.CommandOpendir";
            try {
                Class<?> commandStat = Class.forName(cls);
                Class[] argTypes = new Class[]{String[].class, Socket.class, Logger.class, FileSystem.class};
                Constructor<?> cons = commandStat.getDeclaredConstructor(argTypes);
                Object[] arguments = new Object[]{args, socket, logger, this.fs};
                return (Command)cons.newInstance(arguments);
            }
            catch (ClassNotFoundException e) {
                return new CommandUnknown(args, socket, logger, this.fs);
            }
            catch (NoSuchMethodException e) {
                return new CommandUnknown(args, socket, logger, this.fs);
            }
            catch (InstantiationException e) {
                return new CommandUnknown(args, socket, logger, this.fs);
            }
            catch (IllegalAccessException e) {
                return new CommandUnknown(args, socket, logger, this.fs);
            }
            catch (InvocationTargetException e) {
                return new CommandUnknown(args, socket, logger, this.fs);
            }
        }
        if (command.equals("end")) {
            CommandEnd c = new CommandEnd(args, socket, logger, this.fs);
            c.setPool(this.pool);
            return c;
        }
        if (command.equals("parse")) {
            return new CommandParse(args, socket, logger, this.context, this.fs);
        }
        return new CommandUnknown(args, socket, logger, this.fs);
    }

    public static void fail(String msgId, String reason, Socket socket) {
        reason = msgId + "\u0001fail\u0001" + reason + "\u0001\u0001\u0001\n";
        try {
            BufferedWriter output = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
            output.write(reason);
            output.flush();
            output.close();
            socket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fail(String reason, Socket socket) {
        IOServer.fail("-1", reason, socket);
    }
}

