/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.ioserver.main;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.kframework.compile.FlattenModules;
import org.kframework.compile.transformers.AddTopCellConfig;
import org.kframework.kil.Definition;
import org.kframework.kil.loader.Context;
import org.kframework.krun.K;
import org.kframework.krun.api.io.FileSystem;
import org.kframework.krun.ioserver.filesystem.portable.PortableFileSystem;
import org.kframework.krun.ioserver.main.IOServer;
import org.kframework.utils.BinaryLoader;

public class MainServer
implements Runnable {
    public int _port;
    public boolean _started;
    private Logger _logger;
    protected Context context;
    protected FileSystem fs;

    public MainServer(int port, Logger logger, Context context) {
        this.context = context;
        this._port = port;
        this._logger = logger;
        this.fs = new PortableFileSystem();
    }

    @Override
    public void run() {
        IOServer server = new IOServer(this._port, this._logger, this.context, this.fs);
        this._port = server.port;
        this._started = true;
        try {
            server.acceptConnections();
        }
        catch (IOException e) {
            this._logger.severe("Error accepting connection:" + e);
        }
    }

    public static void main(String[] args) throws Exception {
        Context context = new Context();
        context.kompiled = new File(args[1]);
        Definition javaDef = (Definition)BinaryLoader.load(context.kompiled.getCanonicalPath() + "/defx-maude.bin");
        javaDef = new FlattenModules(context).compile(javaDef, (String)null);
        javaDef = (Definition)javaDef.accept(new AddTopCellConfig(context));
        javaDef.preprocess(context);
        K.parser = args[2];
        Logger logger = Logger.getLogger("KRunner");
        logger.setUseParentHandlers(false);
        MainServer ms = new MainServer(Integer.parseInt(args[0]), logger, context);
        ms.run();
    }
}

