/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.runner;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import org.kframework.kil.loader.Context;
import org.kframework.krun.K;
import org.kframework.krun.ioserver.main.MainServer;
import org.kframework.krun.tasks.MaudeTask;
import org.kframework.utils.file.KPaths;

public class KRunner {
    private OptionParser _parser = new OptionParser();
    private Logger _logger;
    private File _maudeFile;
    private String _maudeFileName;
    private File _maudeCommandFile;
    private String _maudeCommandFileName;
    private int _port;
    private boolean _append;
    private String _outputFileName;
    private String _errorFileName;
    private String _maudeModule;
    private boolean _createLogs;
    private boolean _noServer;
    protected Context context;

    public KRunner(String[] args, Context context) throws Exception {
        this.context = context;
        ArgumentAcceptingOptionSpec<File> maudeFile = this._parser.accepts("maudeFile", "Maude file to run").withRequiredArg().required().ofType(File.class);
        ArgumentAcceptingOptionSpec<Integer> port = this._parser.accepts("port", "Port to use for IO server").withRequiredArg().ofType(Integer.class).defaultsTo(0, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<Boolean> append = this._parser.accepts("appendLogs", "Whether or not messages should be appended to log files").withRequiredArg().ofType(Boolean.class).defaultsTo(false, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<File> outputFile = this._parser.accepts("outputFile", "File to save resulting term").withRequiredArg().ofType(File.class).defaultsTo(new File("/dev/stdout"), (File[])new File[0]);
        ArgumentAcceptingOptionSpec<File> errorFile = this._parser.accepts("errorFile", "File to save any Maude errors").withRequiredArg().ofType(File.class).defaultsTo(new File("/dev/stdout"), (File[])new File[0]);
        ArgumentAcceptingOptionSpec<File> maudeCommandFile = this._parser.accepts("commandFile", "File containing maude command").withRequiredArg().required().ofType(File.class);
        ArgumentAcceptingOptionSpec<String> maudeModuleName = this._parser.accepts("moduleName", "Final module name").withRequiredArg().required().ofType(String.class);
        OptionSpecBuilder createLogs = this._parser.accepts("createLogs", "Create runtime log files");
        OptionSpecBuilder noServer = this._parser.accepts("noServer", "Don't start the IO server");
        try {
            OptionSet options = this._parser.parse(args);
            this._maudeFile = options.valueOf(maudeFile);
            this._maudeFileName = this._maudeFile.getCanonicalPath();
            this._maudeCommandFile = options.valueOf(maudeCommandFile);
            this._maudeCommandFileName = this._maudeCommandFile.getCanonicalPath();
            this._port = options.valueOf(port);
            this._append = options.valueOf(append);
            this._outputFileName = options.valueOf(outputFile).getCanonicalPath();
            this._errorFileName = options.valueOf(errorFile).getCanonicalPath();
            this._maudeModule = options.valueOf(maudeModuleName);
            this._createLogs = options.has(createLogs);
            this._noServer = options.has(noServer);
        }
        catch (OptionException e) {
            System.out.println(e.getMessage() + K.lineSeparator);
            this.usageError();
        }
        this.startLogger();
        if (!this._maudeFile.exists()) {
            throw new Exception("Maude file " + this._maudeFileName + " does not exist.");
        }
        if (!this._maudeCommandFile.exists()) {
            System.out.println("commandFileName:" + this._maudeCommandFileName);
            throw new Exception("Command file " + this._maudeCommandFileName + " does not exist.");
        }
        this._logger.info("Maude and command files exist.");
    }

    private void startLogger() throws IOException {
        this._logger = Logger.getLogger("KRunner");
        if (this._createLogs) {
            FileHandler fh = new FileHandler("krunner.log", this._append);
            fh.setFormatter(new SimpleFormatter());
            this._logger.addHandler(fh);
        }
        this._logger.setUseParentHandlers(false);
    }

    Thread startServer() {
        this._logger.info("Trying to start server on port " + this._port);
        MainServer server = new MainServer(this._port, this._logger, this.context);
        Thread t = new Thread(server);
        t.start();
        while (!server._started) {
            Thread.yield();
        }
        this._port = server._port;
        this._logger.info("Server started on port " + this._port);
        return t;
    }

    public int run() throws Exception {
        if (!this._noServer) {
            this.startServer();
        }
        this._maudeFileName = KPaths.windowfyPath(this._maudeFileName);
        this._maudeCommandFileName = KPaths.windowfyPath(this._maudeCommandFileName);
        String commandTemplate = "load {0}" + K.lineSeparator + "mod KRUNNER is including {1} ." + K.lineSeparator + "eq #TCPPORT = {2,number,#} ." + K.lineSeparator + "endm" + K.lineSeparator + "load {3}" + K.lineSeparator;
        String command = MessageFormat.format(commandTemplate, this._maudeFileName, this._maudeModule, this._port, this._maudeCommandFileName);
        MaudeTask maude = new MaudeTask(command, this._outputFileName, this._errorFileName);
        maude.start();
        this._logger.info("Maude started");
        this._logger.info("Maude command:" + K.lineSeparator + command);
        maude.join();
        return maude.returnValue;
    }

    public static int main(String[] args, Context context) throws Exception {
        KRunner runner = new KRunner(args, context);
        return runner.run();
    }

    void usageError() throws IOException {
        this._parser.printHelpOn(System.out);
        System.out.println("");
        System.exit(1);
    }
}

