/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.krun.tasks;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import org.kframework.krun.K;
import org.kframework.utils.maude.MaudeRun;

public class MaudeTask
extends Thread {
    private String _command;
    private String _outputFile;
    private String _errorFile;
    private Process _maudeProcess;
    public int returnValue;
    public static String maudeExe = MaudeRun.initializeMaudeExecutable();

    public MaudeTask(String command, String outputFile, String errorFile) {
        this._command = command;
        this._outputFile = outputFile;
        this._errorFile = errorFile;
    }

    @Override
    public void run() {
        try {
            this.runMaude();
            this.runCommand();
            this.writeOutput();
            this.writeError();
            this.returnValue = this._maudeProcess.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void runMaude() throws IOException {
        Process maudeProcess;
        ProcessBuilder maude = new ProcessBuilder(new String[0]);
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(maudeExe);
        commands.add("-no-wrap");
        commands.add("-no-banner");
        commands.add("-xml-log=" + K.maude_output);
        maude.command(commands);
        this._maudeProcess = maudeProcess = maude.start();
    }

    private void runCommand() throws IOException {
        BufferedWriter maudeInput = new BufferedWriter(new OutputStreamWriter(this._maudeProcess.getOutputStream()));
        maudeInput.write(this._command + K.lineSeparator);
        maudeInput.close();
    }

    private void writeOutput() throws IOException {
        String line;
        BufferedReader maudeOutput = new BufferedReader(new InputStreamReader(this._maudeProcess.getInputStream()));
        BufferedWriter outputFile = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this._outputFile)));
        while ((line = maudeOutput.readLine()) != null) {
            outputFile.write(line + K.lineSeparator);
        }
        maudeOutput.close();
        outputFile.close();
    }

    private void writeError() throws IOException {
        try (BufferedReader maudeError = new BufferedReader(new InputStreamReader(this._maudeProcess.getErrorStream()));
             BufferedWriter errorFile = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this._errorFile)));){
            String line;
            while ((line = maudeError.readLine()) != null) {
                errorFile.write(line + K.lineSeparator);
            }
        }
    }
}

