/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.ktest.CmdArgs;

import java.io.File;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.io.FilenameUtils;
import org.kframework.krun.ColorSetting;
import org.kframework.ktest.CmdArgs.InvalidArgumentException;
import org.kframework.ktest.IgnoringStringComparator;
import org.kframework.ktest.KTestStep;

public class CmdArg {
    private String directory;
    private String programs;
    private String results;
    private final String[] extensions;
    private final String[] excludes;
    private final Set<KTestStep> skips;
    private final int threads;
    private final boolean generateReport;
    private String targetFile;
    private final boolean verbose;
    private final ColorSetting colorSetting;
    private final int timeout;
    private final boolean updateOut;
    private final boolean generateOut;
    private final boolean ignoreWS;
    private final boolean ignoreBalancedParens;
    private final boolean dry;

    private CmdArg(String directory, String programs, String results, String[] extensions, String[] excludes, Set<KTestStep> skips, int threads, boolean generateReport, String targetFile, boolean verbose, ColorSetting colorSetting, int timeout, boolean updateOut, boolean generateOut, boolean ignoreWS, boolean ignoreBalancedParens, boolean dry) {
        this.directory = directory;
        this.programs = programs;
        this.results = results;
        this.extensions = extensions;
        this.excludes = excludes;
        this.skips = skips;
        this.threads = threads;
        this.generateReport = generateReport;
        this.targetFile = targetFile;
        this.verbose = verbose;
        this.colorSetting = colorSetting;
        this.timeout = timeout;
        this.updateOut = updateOut;
        this.generateOut = generateOut;
        this.ignoreWS = ignoreWS;
        this.ignoreBalancedParens = ignoreBalancedParens;
        this.dry = dry;
    }

    public CmdArg(CmdArg obj) {
        this.directory = obj.directory;
        this.programs = obj.programs;
        this.results = obj.results;
        this.extensions = obj.extensions;
        this.excludes = obj.excludes;
        this.skips = obj.skips;
        this.threads = obj.threads;
        this.generateReport = obj.generateReport;
        this.targetFile = obj.targetFile;
        this.verbose = obj.verbose;
        this.colorSetting = obj.colorSetting;
        this.timeout = obj.timeout;
        this.updateOut = obj.updateOut;
        this.generateOut = obj.generateOut;
        this.ignoreWS = obj.ignoreWS;
        this.ignoreBalancedParens = obj.ignoreBalancedParens;
        this.dry = obj.dry;
    }

    public static CmdArg validateArgs(CommandLine cmdOpts) throws InvalidArgumentException {
        String currentDir = System.getProperty("user.dir");
        String[] args = cmdOpts.getArgs();
        if (args.length != 1) {
            throw new InvalidArgumentException("ktest requires exactly one <file> parameter.");
        }
        String targetFile = FilenameUtils.concat(currentDir, args[0]);
        if (!new File(targetFile).isFile()) {
            throw new InvalidArgumentException("target file argument is not a valid file: " + targetFile);
        }
        String ext = FilenameUtils.getExtension(targetFile);
        if (!ext.equals("xml") && !ext.equals("k")) {
            throw new InvalidArgumentException("target file format is not valid: " + ext + "(should be .xml or .k)");
        }
        String directory = CmdArg.getDirectoryArg(cmdOpts, "directory", currentDir);
        String programs = CmdArg.getDirectoryArg(cmdOpts, "programs", FilenameUtils.concat(currentDir, FilenameUtils.getFullPath(targetFile)));
        String results = CmdArg.getDirectoryArg(cmdOpts, "results", FilenameUtils.concat(currentDir, FilenameUtils.getFullPath(targetFile)));
        String[] extensions = cmdOpts.getOptionValue("extension", "").split("\\s+");
        String[] excludes = new String[]{};
        if (cmdOpts.hasOption("exclude")) {
            excludes = cmdOpts.getOptionValue("exclude").split("\\s+");
        }
        boolean generateReport = cmdOpts.hasOption("report");
        boolean verbose = cmdOpts.hasOption("verbose");
        boolean updateOut = cmdOpts.hasOption("update-out");
        boolean generateOut = cmdOpts.hasOption("generate-out");
        if (updateOut && generateOut) {
            throw new InvalidArgumentException("cannot have both options at once: --update-out and --generate-out");
        }
        boolean ignoreWS = true;
        if (cmdOpts.hasOption("ignore-white-spaces") && cmdOpts.getOptionValue("ignore-white-spaces").equals("off")) {
            ignoreWS = false;
        }
        boolean ignoreBalancedParens = true;
        if (cmdOpts.hasOption("ignore-balanced-parentheses") && cmdOpts.getOptionValue("ignore-balanced-parentheses").equals("off")) {
            ignoreBalancedParens = false;
        }
        boolean dry = cmdOpts.hasOption("dry");
        return new CmdArg(directory, programs, results, extensions, excludes, CmdArg.parseSkips(cmdOpts), CmdArg.parseThreads(cmdOpts), generateReport, targetFile, verbose, CmdArg.parseColorSetting(cmdOpts), CmdArg.parseTimeout(cmdOpts), updateOut, generateOut, ignoreWS, ignoreBalancedParens, dry);
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getPrograms() {
        return this.programs;
    }

    public String getResults() {
        return this.results;
    }

    public String getTargetFile() {
        return this.targetFile;
    }

    public Set<KTestStep> getSkips() {
        return this.skips;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public ColorSetting getColorSetting() {
        return this.colorSetting;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean getUpdateOut() {
        return this.updateOut;
    }

    public boolean getGenerateOut() {
        return this.generateOut;
    }

    public boolean getGenerateReport() {
        return this.generateReport;
    }

    public boolean getDry() {
        return this.dry;
    }

    public int getThreads() {
        return this.threads;
    }

    public CmdArg setDirectory(String directory) {
        this.directory = directory;
        return this;
    }

    public CmdArg setPrograms(String programs) {
        this.programs = programs;
        return this;
    }

    public CmdArg setResults(String results) {
        this.results = results;
        return this;
    }

    public CmdArg setTargetFile(String targetFile) {
        this.targetFile = targetFile;
        return this;
    }

    public Comparator<String> getStringComparator() {
        return new IgnoringStringComparator(this.ignoreWS, this.ignoreBalancedParens);
    }

    private static int parseTimeout(CommandLine cmdOpts) throws InvalidArgumentException {
        String timeout_str = cmdOpts.getOptionValue("timeout", "300000");
        try {
            return Integer.parseInt(timeout_str);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException("timeout value is not an integer: " + timeout_str);
        }
    }

    private static Set<KTestStep> parseSkips(CommandLine cmdOpts) throws InvalidArgumentException {
        HashSet<KTestStep> skips = new HashSet<KTestStep>();
        block12: for (String s : cmdOpts.getOptionValue("skip", "").split("\\s+")) {
            switch (s.trim()) {
                case "kompile": {
                    skips.add(KTestStep.KOMPILE);
                    continue block12;
                }
                case "pdf": {
                    skips.add(KTestStep.PDF);
                    continue block12;
                }
                case "krun": {
                    skips.add(KTestStep.KRUN);
                    continue block12;
                }
                case "": {
                    continue block12;
                }
                default: {
                    throw new InvalidArgumentException("--skip option should be [kompile|pdf|krun]+");
                }
            }
        }
        return skips;
    }

    private static ColorSetting parseColorSetting(CommandLine cmdOpts) throws InvalidArgumentException {
        String s;
        switch (s = cmdOpts.getOptionValue("color", "on")) {
            case "on": {
                return ColorSetting.ON;
            }
            case "off": {
                return ColorSetting.OFF;
            }
            case "extended": {
                return ColorSetting.EXTENDED;
            }
        }
        throw new InvalidArgumentException("--color option should be [on|off|extended]");
    }

    private static String getDirectoryArg(CommandLine cmdOpts, String argName, String default_) throws InvalidArgumentException {
        String ret = cmdOpts.getOptionValue(argName, default_);
        File f = new File(ret);
        if (!f.isDirectory()) {
            throw new InvalidArgumentException("--" + argName + " argument is not a folder: " + ret);
        }
        return f.getAbsolutePath();
    }

    private static int parseThreads(CommandLine cmdOpts) throws InvalidArgumentException {
        String threadsStr = cmdOpts.getOptionValue("threads");
        int threads = Runtime.getRuntime().availableProcessors();
        if (threadsStr != null) {
            try {
                threads = Integer.valueOf(threadsStr);
            }
            catch (NumberFormatException e) {
                throw new InvalidArgumentException("--threads argument should be an integer greater than 0");
            }
        }
        if (threads <= 0) {
            throw new InvalidArgumentException("--threads argument should be an integer greater than 0");
        }
        return threads;
    }
}

