/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.ktest.CmdArgs;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class CmdArgParser {
    public final CommandLine cmdOpts;
    private final Options options = new Options();
    private final List<Option> optionList = new ArrayList<Option>();

    public CmdArgParser(String[] args) throws ParseException {
        OptionBuilder.withLongOpt("help");
        OptionBuilder.withDescription("Print this help message.");
        this.addOption(OptionBuilder.create("h"));
        OptionBuilder.withLongOpt("version");
        OptionBuilder.withDescription("Print version information.");
        this.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("verbose");
        OptionBuilder.withDescription("Verbose output.");
        this.addOption(OptionBuilder.create("v"));
        OptionBuilder.withLongOpt("color");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("[on|off|extended]");
        OptionBuilder.withDescription("Use colors in output. (Default: on)");
        this.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("programs");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("dir");
        OptionBuilder.withDescription("Programs directory in single job mode, or a root directory for programs in batch mode. By default this is the directory where <file> reside.");
        this.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("extension");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("string");
        OptionBuilder.withDescription("The list of program extensions separated by whitespaces. Required in single job mode, invalid in batch mode.");
        this.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("exclude");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("file");
        OptionBuilder.withDescription("The list of programs which will not be tested. Valid only in single job mode.");
        this.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("results");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("dir");
        OptionBuilder.withDescription("Directory containing input and expected output for programs in single job mode, or a root directory for the expected I/O for programs in batch mode. By default this is the directory where <file> reside.");
        this.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("skip");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("steps");
        OptionBuilder.withDescription("The list of steps to be skipped, separated by whitespace. A step is either [kompile|pdf|krun].");
        this.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("directory");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("dir");
        OptionBuilder.withDescription("A root directory where K definitions reside. By default this is the current directory. Valid only in batch mode.");
        this.addOption(OptionBuilder.create("d"));
        OptionBuilder.withLongOpt("report");
        OptionBuilder.withDescription("Generate a junit-like report.");
        this.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("timeout");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("num");
        OptionBuilder.withDescription("Time limit for each process (milliseconds). Default is 300000 milliseconds.");
        this.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("update-out");
        OptionBuilder.withDescription("Update existing .out files.");
        this.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("generate-out");
        OptionBuilder.withDescription("Newly generate .out files if needed.");
        this.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("threads");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("threads");
        OptionBuilder.withDescription("Maximum number of threads spawned for parallel execution.");
        this.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("ignore-white-spaces");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("on|off");
        OptionBuilder.withDescription("Ignore white spaces when comparing results. (Default: on).");
        this.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("ignore-balanced-parentheses");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("on|off");
        OptionBuilder.withDescription("Ignore balanced parentheses when comparing results. (Default: on).");
        this.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("dry");
        OptionBuilder.withDescription("Dry run: print out the command to be executed without actual execution.");
        this.addOption(OptionBuilder.create());
        this.cmdOpts = new PosixParser().parse(this.options, args);
    }

    private void addOption(Option option) {
        this.options.addOption(option);
        this.optionList.add(option);
    }

    public List<Option> getOptionList() {
        return this.optionList;
    }

    public Options getOptions() {
        return this.options;
    }
}

