/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.ktest.Config;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.io.FilenameUtils;
import org.kframework.ktest.Annotated;
import org.kframework.ktest.CmdArgs.CmdArg;
import org.kframework.ktest.Config.ConfigPreProcessor;
import org.kframework.ktest.Config.InvalidConfigError;
import org.kframework.ktest.Config.LocationData;
import org.kframework.ktest.KTest;
import org.kframework.ktest.KTestStep;
import org.kframework.ktest.PgmArg;
import org.kframework.ktest.Test.TestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ConfigFileParser {
    private final Document doc;
    private final CmdArg cmdArgs;

    public ConfigFileParser(File configFile, CmdArg cmdArgs) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        this.cmdArgs = cmdArgs;
        StreamSource schemaFile = new StreamSource(new File(this.getSchema()));
        StreamSource xmlFile = new StreamSource(configFile);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(schemaFile);
        Validator validator = schema.newValidator();
        validator.validate(xmlFile);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer nullTransformer = transformerFactory.newTransformer();
        DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
        this.doc = docBuilder.newDocument();
        DOMResult domResult = new DOMResult(this.doc);
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        ConfigPreProcessor locationAnnotator = new ConfigPreProcessor(xmlReader, this.doc);
        String systemId = configFile.getAbsolutePath();
        InputSource inputSource = new InputSource(systemId);
        SAXSource saxSource = new SAXSource(locationAnnotator, inputSource);
        nullTransformer.transform(saxSource, domResult);
    }

    public List<TestCase> parse() throws InvalidConfigError {
        NodeList testsNode = this.doc.getElementsByTagName("tests");
        NodeList tests = testsNode.item(0).getChildNodes();
        return this.parseTestCases(tests);
    }

    private List<TestCase> parseTestCases(NodeList tests) throws InvalidConfigError {
        LinkedList<TestCase> testCases = new LinkedList<TestCase>();
        block8: for (int testNodeIdx = 0; testNodeIdx < tests.getLength(); ++testNodeIdx) {
            if (tests.item(testNodeIdx).getNodeType() != 1) continue;
            Element node = (Element)tests.item(testNodeIdx);
            switch (node.getNodeName()) {
                case "test": {
                    testCases.add(this.parseTestCase(node));
                    continue block8;
                }
                case "include": {
                    testCases.addAll(this.parseInclude(node));
                    continue block8;
                }
                default: {
                    assert (false);
                    continue block8;
                }
            }
        }
        return testCases;
    }

    private List<TestCase> parseInclude(Element includeNode) throws InvalidConfigError {
        ConfigFileParser configFileParser;
        NamedNodeMap includeAttrs = includeNode.getAttributes();
        LocationData location = (LocationData)includeNode.getUserData("locationDataKey");
        String fileValue = includeAttrs.getNamedItem("file").getNodeValue();
        String file = this.concat(FilenameUtils.getFullPath(this.cmdArgs.getTargetFile()), fileValue);
        if (!new File(file).isFile()) {
            throw new InvalidConfigError("file attribute " + file + " in `include' is not a valid file", location);
        }
        String directory = this.concat(this.cmdArgs.getDirectory(), this.getAttributeWDefault(includeAttrs, "directory", ""));
        String programs = this.concat(this.cmdArgs.getPrograms(), this.getAttributeWDefault(includeAttrs, "programs", FilenameUtils.getFullPath(file)));
        String results = this.concat(this.cmdArgs.getResults(), this.getAttributeWDefault(includeAttrs, "results", FilenameUtils.getFullPath(file)));
        CmdArg cmdArgs1 = new CmdArg(this.cmdArgs).setDirectory(directory).setPrograms(programs).setResults(results).setTargetFile(file);
        try {
            configFileParser = new ConfigFileParser(new File(file), cmdArgs1);
        }
        catch (Exception e) {
            throw new InvalidConfigError("error occured while parsing included file " + file + ":\n" + e.getMessage(), location);
        }
        List<TestCase> ret = configFileParser.parse();
        NodeList childNodes = includeNode.getChildNodes();
        if (includeAttrs.getNamedItem("exclude") != null) {
            this.overrideExcludes(ret, this.splitNodeValue(includeAttrs.getNamedItem("exclude")));
        }
        if (this.hasElement(childNodes, "kompile-option")) {
            this.overrideKompileOptions(ret, this.parseKompileOpts(childNodes));
        }
        if (this.hasElement(childNodes, "all-programs")) {
            this.overrideKrunOpts(ret, this.parseAllPgmsKrunOpts(childNodes));
        }
        if (this.hasElement(childNodes, "program")) {
            this.overridePgmSpecificKRunOpts(ret, this.parsePgmSpecificKRunOpts(childNodes));
        }
        if (includeAttrs.getNamedItem("more-programs") != null) {
            for (String p : this.splitNodeValue(includeAttrs.getNamedItem("more-programs"))) {
                this.extendPrograms(ret, this.annotate(this.normalize(p, this.cmdArgs.getPrograms()), location));
            }
        }
        if (includeAttrs.getNamedItem("more-results") != null) {
            for (String r : this.splitNodeValue(includeAttrs.getNamedItem("more-results"))) {
                this.extendResults(ret, this.annotate(this.normalize(r, this.cmdArgs.getPrograms()), location));
            }
        }
        for (TestCase tc : ret) {
            tc.validate();
        }
        return ret;
    }

    private void overrideExcludes(List<TestCase> tests, String[] excludes) {
        for (TestCase tc : tests) {
            tc.setExcludes(excludes);
        }
    }

    private void overrideKompileOptions(List<TestCase> tests, List<PgmArg> kompileOpts) {
        for (TestCase tc : tests) {
            tc.setKompileOpts(kompileOpts);
        }
    }

    private void overrideKrunOpts(List<TestCase> tests, List<PgmArg> krunOpts) {
        for (TestCase tc : tests) {
            tc.setKrunOpts(krunOpts);
        }
    }

    private void overridePgmSpecificKRunOpts(List<TestCase> tests, Map<String, List<PgmArg>> pgmSpecificKrunOpts) {
        for (TestCase tc : tests) {
            tc.setPgmSpecificKRunOpts(pgmSpecificKrunOpts);
        }
    }

    private void extendPrograms(List<TestCase> tests, Annotated<String, LocationData> p) {
        for (TestCase tc : tests) {
            tc.addProgram(p);
        }
    }

    private void extendResults(List<TestCase> tests, Annotated<String, LocationData> r) {
        for (TestCase tc : tests) {
            tc.addResult(r);
        }
    }

    private boolean hasElement(NodeList nodes, String elemName) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (!nodes.item(i).getNodeName().equals(elemName)) continue;
            return true;
        }
        return false;
    }

    private TestCase parseTestCase(Element testNode) throws InvalidConfigError {
        NamedNodeMap testAttrs = testNode.getAttributes();
        LocationData location = (LocationData)testNode.getUserData("locationDataKey");
        Node definitionNode = testAttrs.getNamedItem("definition");
        Annotated<String, LocationData> definition = this.annotate(this.normalize(this.addDefinitionExt(definitionNode.getNodeValue()), this.cmdArgs.getDirectory()), location);
        List<Annotated<String, LocationData>> programs = this.annotateLst(this.normalize(this.splitNodeValue(testAttrs.getNamedItem("programs")), this.cmdArgs.getPrograms()), location);
        List<Annotated<String, LocationData>> results = this.annotateLst(this.normalize(this.splitNodeValue(testAttrs.getNamedItem("results")), this.cmdArgs.getResults()), location);
        String[] extensions = this.splitNodeValue(testAttrs.getNamedItem("extension"));
        String[] excludes = this.splitNodeValue(testAttrs.getNamedItem("exclude"));
        Set<KTestStep> skips = this.parseSkips(testAttrs.getNamedItem("skip"), location);
        NodeList childNodes = testNode.getChildNodes();
        List<PgmArg> kompileOpts = this.parseKompileOpts(childNodes);
        List<PgmArg> krunOpts = this.parseAllPgmsKrunOpts(childNodes);
        Map<String, List<PgmArg>> pgmSpecificKRunOpts = this.parsePgmSpecificKRunOpts(childNodes);
        TestCase ret = new TestCase(definition, programs, extensions, excludes, results, kompileOpts, krunOpts, pgmSpecificKRunOpts, skips);
        ret.validate();
        return ret;
    }

    private String addDefinitionExt(String nodeValue) {
        if (FilenameUtils.getExtension(nodeValue).equals("k")) {
            return nodeValue;
        }
        return nodeValue + ".k";
    }

    private Set<KTestStep> parseSkips(Node node, LocationData location) throws InvalidConfigError {
        HashSet<KTestStep> skips = new HashSet<KTestStep>();
        if (node == null) {
            return skips;
        }
        block12: for (String s : node.getNodeValue().split("\\s+")) {
            switch (s.trim()) {
                case "kompile": {
                    skips.add(KTestStep.KOMPILE);
                    continue block12;
                }
                case "pdf": {
                    skips.add(KTestStep.PDF);
                    continue block12;
                }
                case "krun": {
                    skips.add(KTestStep.KRUN);
                    continue block12;
                }
                case "": {
                    continue block12;
                }
                default: {
                    throw new InvalidConfigError("skip attribute option should be [kompile|pdf|krun]+", location);
                }
            }
        }
        return skips;
    }

    private Annotated<String, LocationData> annotate(String str, LocationData location) {
        return new Annotated<String, LocationData>(str, location);
    }

    private List<Annotated<String, LocationData>> annotateLst(String[] strs, LocationData location) {
        LinkedList<Annotated<String, LocationData>> ret = new LinkedList<Annotated<String, LocationData>>();
        for (String str : strs) {
            ret.add(this.annotate(str, location));
        }
        return ret;
    }

    private String normalize(String path, String root) {
        return this.concat(root, path);
    }

    private String[] normalize(String[] paths, String root) {
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = this.concat(root, paths[i]);
        }
        return paths;
    }

    private List<PgmArg> parseKompileOpts(NodeList nodes) {
        LinkedList<PgmArg> ret = new LinkedList<PgmArg>();
        for (int childNodeIdx = 0; childNodeIdx < nodes.getLength(); ++childNodeIdx) {
            Node childNode = nodes.item(childNodeIdx);
            if (childNode.getNodeType() != 1 || !childNode.getNodeName().equals("kompile-option")) continue;
            Element elem = (Element)childNode;
            String name = elem.getAttribute("name");
            while (name.startsWith("-")) {
                name = name.substring(1);
            }
            ret.add(new PgmArg(name, elem.getAttribute("value")));
        }
        return ret;
    }

    private List<PgmArg> parseAllPgmsKrunOpts(NodeList nodes) {
        LinkedList<PgmArg> ret = new LinkedList<PgmArg>();
        for (int childNodeIdx = 0; childNodeIdx < nodes.getLength(); ++childNodeIdx) {
            Node childNode = nodes.item(childNodeIdx);
            if (childNode.getNodeType() != 1 || !childNode.getNodeName().equals("all-programs")) continue;
            ret.addAll(this.parseKrunOpts(childNode.getChildNodes()));
        }
        return ret;
    }

    private List<PgmArg> parseKrunOpts(NodeList nodes) {
        LinkedList<PgmArg> ret = new LinkedList<PgmArg>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getNodeType() != 1 || !n.getNodeName().equals("krun-option")) continue;
            Element e = (Element)n;
            String name = e.getAttribute("name");
            while (name.startsWith("-")) {
                name = name.substring(1);
            }
            ret.add(new PgmArg(name, e.getAttribute("value")));
        }
        return ret;
    }

    private Map<String, List<PgmArg>> parsePgmSpecificKRunOpts(NodeList nodes) {
        HashMap<String, List<PgmArg>> ret = new HashMap<String, List<PgmArg>>();
        for (int childNodeIdx = 0; childNodeIdx < nodes.getLength(); ++childNodeIdx) {
            Node childNode = nodes.item(childNodeIdx);
            if (childNode.getNodeType() != 1 || !childNode.getNodeName().equals("program")) continue;
            Element elem = (Element)childNode;
            ret.put(elem.getAttribute("name"), this.parseKrunOpts(elem.getChildNodes()));
        }
        return ret;
    }

    private String[] splitNodeValue(Node node) {
        if (node == null) {
            return new String[0];
        }
        return node.getNodeValue().split("\\s+");
    }

    private String getAttributeWDefault(NamedNodeMap attrs, String name, String def) {
        Node n = attrs.getNamedItem(name);
        if (n == null) {
            return def;
        }
        return n.getNodeValue();
    }

    private String getSchema() {
        return this.concat(this.getKHome(), this.concat("lib", "ktest.xsd"));
    }

    private String getKHome() {
        return new File(KTest.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParentFile().getParentFile().getParentFile().getPath();
    }

    private String concat(String s1, String s2) {
        String ret = FilenameUtils.concat(s1, s2);
        assert (ret != null) : "concat(" + s1 + ", " + s2 + ") returned null";
        if (ret.equals("")) {
            return ".";
        }
        return ret;
    }
}

