/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.ktest.Config;

import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kframework.ktest.Config.LocationData;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.LocatorImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class ConfigPreProcessor
extends XMLFilterImpl {
    private Locator locator;
    private final Stack<Locator> locatorStack = new Stack();
    private final Stack<Element> elementStack = new Stack();
    private final UserDataHandler dataHandler = new LocationDataHandler();

    ConfigPreProcessor(XMLReader xmlReader, Document dom) {
        super(xmlReader);
        EventListener modListener = new EventListener(){

            @Override
            public void handleEvent(Event e) {
                EventTarget target = e.getTarget();
                ConfigPreProcessor.this.elementStack.push((Element)((Object)target));
            }
        };
        ((EventTarget)((Object)dom)).addEventListener("DOMNodeInserted", modListener, true);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        super.startElement(uri, localName, qName, atts);
        this.locatorStack.push(new LocatorImpl(this.locator));
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if (this.locatorStack.size() > 0) {
            Locator startLocator = this.locatorStack.pop();
            LocationData location = new LocationData(startLocator.getSystemId(), startLocator.getLineNumber(), startLocator.getColumnNumber(), this.locator.getLineNumber(), this.locator.getColumnNumber());
            Element elem = this.elementStack.pop();
            elem.setUserData("locationDataKey", location, this.dataHandler);
            NamedNodeMap nodes = elem.getAttributes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                node.setNodeValue(this.resolveEnvVars(node.getNodeValue()));
            }
        }
    }

    private String resolveEnvVars(String str) {
        Matcher m = Pattern.compile("\\$\\{(.*?)\\}").matcher(str);
        if (m.find()) {
            String var = m.group(1);
            String val = System.getenv(var);
            if (val != null) {
                return this.resolveEnvVars(m.replaceFirst(val));
            }
            String msg = "The variable is not defined in the system environment: " + var;
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, "command line", "System file."));
            return null;
        }
        return str;
    }

    private class LocationDataHandler
    implements UserDataHandler {
        private LocationDataHandler() {
        }

        @Override
        public void handle(short operation, String key, Object data, Node src, Node dst) {
            LocationData locatonData;
            if (src != null && dst != null && (locatonData = (LocationData)src.getUserData("locationDataKey")) != null) {
                dst.setUserData("locationDataKey", locatonData, ConfigPreProcessor.this.dataHandler);
            }
        }
    }
}

