/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.ktest;

import java.util.Comparator;

public class IgnoringStringComparator
implements Comparator<String> {
    private final boolean ignoreWS;
    private final boolean ignoreBalancedParens;

    public IgnoringStringComparator(boolean ignoreWS, boolean ignoreBalancedParens) {
        this.ignoreWS = ignoreWS;
        this.ignoreBalancedParens = ignoreBalancedParens;
    }

    @Override
    public int compare(String s1, String s2) {
        if (this.ignoreWS) {
            s1 = s1.replaceAll("\\r|\\s|\\n", "");
            s2 = s2.replaceAll("\\r|\\s|\\n", "");
            s1 = s1.replaceAll("\u001b\\[[;\\d]*m", "");
            s2 = s2.replaceAll("\u001b\\[[;\\d]*m", "");
        } else {
            s1 = s1.replaceAll("\\r", "");
            s2 = s2.replaceAll("\\r", "");
        }
        if (this.ignoreBalancedParens) {
            s1 = IgnoringStringComparator.removeAllBalanced(s1);
            s2 = IgnoringStringComparator.removeAllBalanced(s2);
        }
        return s1.trim().compareTo(s2.trim());
    }

    private static String removeAllBalanced(String s1) {
        String s2 = s1.replaceAll("\\((.*?)\\)", "$1").replaceAll("\\{(.*?)\\}", "$1").replaceAll("\\[(.*?)\\]", "$1");
        if (s1.equals(s2)) {
            return s1;
        }
        return IgnoringStringComparator.removeAllBalanced(s2);
    }
}

