/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.ktest;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FilenameUtils;
import org.kframework.ktest.CmdArgs.CmdArg;
import org.kframework.ktest.CmdArgs.CmdArgParser;
import org.kframework.ktest.CmdArgs.InvalidArgumentException;
import org.kframework.ktest.Config.ConfigFileParser;
import org.kframework.ktest.Config.InvalidConfigError;
import org.kframework.ktest.Config.LocationData;
import org.kframework.ktest.Test.TestCase;
import org.kframework.ktest.Test.TestSuite;
import org.kframework.utils.Error;
import org.kframework.utils.OptionComparator;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.file.FileUtil;
import org.kframework.utils.file.KPaths;
import org.kframework.utils.general.GlobalSettings;
import org.xml.sax.SAXException;

public class KTest {
    private final CmdArgParser argParser;

    private KTest(String[] args) throws ParseException {
        this.argParser = new CmdArgParser(args);
    }

    public int run() throws InvalidArgumentException, IOException, SAXException, ParserConfigurationException, InterruptedException, InvalidConfigError, TransformerException {
        if (this.argParser.cmdOpts.hasOption("help")) {
            this.printHelpMsg();
        } else if (this.argParser.cmdOpts.hasOption("version")) {
            this.printVersion();
        } else {
            CmdArg cmdArgs = CmdArg.validateArgs(this.argParser.cmdOpts);
            TestSuite testSuite = this.makeTestSuite(cmdArgs.getTargetFile(), cmdArgs);
            if (cmdArgs.getDry()) {
                testSuite.dryRun();
            } else {
                return testSuite.run() ? 0 : 1;
            }
        }
        return 0;
    }

    private TestSuite makeTestSuite(String targetFile, CmdArg cmdArgs) throws SAXException, TransformerException, ParserConfigurationException, IOException, InvalidConfigError {
        TestSuite ret;
        switch (FilenameUtils.getExtension(targetFile)) {
            case "xml": {
                ret = new TestSuite(new ConfigFileParser(new File(cmdArgs.getTargetFile()), cmdArgs).parse(), cmdArgs);
                break;
            }
            case "k": {
                TestCase tc = TestCase.makeTestCaseFromK(cmdArgs);
                tc.validate();
                LinkedList<TestCase> tcs = new LinkedList<TestCase>();
                tcs.add(tc);
                ret = new TestSuite(tcs, cmdArgs);
                break;
            }
            default: {
                ret = null;
                assert (false);
                break;
            }
        }
        return ret;
    }

    private void printHelpMsg() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setWidth(79);
        String usage = "ktest <file> [options]";
        String header = "<file> is either a K definition (single job mode) or an XML configuration (batch mode).";
        String footer = "";
        Error.helpMsg("ktest <file> [options]", "<file> is either a K definition (single job mode) or an XML configuration (batch mode).", "", this.argParser.getOptions(), new OptionComparator(this.argParser.getOptionList()));
    }

    private void printVersion() {
        System.out.println(FileUtil.getFileContent(KPaths.getKBase(false) + KPaths.VERSION_FILE));
    }

    public static void main(String[] args) {
        try {
            System.exit(new KTest(args).run());
        }
        catch (IOException | InterruptedException | ParserConfigurationException | TransformerException | ParseException | InvalidArgumentException | SAXException e) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, e.getMessage(), "command line", "System file."));
        }
        catch (InvalidConfigError e) {
            LocationData location = e.getLocation();
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, e.getMessage(), location.getSystemId(), location.getPosStr()));
        }
        System.exit(1);
    }
}

