/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.ktest;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;
import org.kframework.krun.ColorSetting;
import org.kframework.ktest.Annotated;
import org.kframework.ktest.StreamGobbler;
import org.kframework.utils.ColorUtil;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class Proc<T>
implements Runnable {
    private final String[] args;
    private final Annotated<String, String> expectedOut;
    private String pgmOut;
    private final Annotated<String, String> expectedErr;
    private String pgmErr;
    private final String procInput;
    private final String logStr;
    private final Comparator<String> strComparator;
    private final T obj;
    private final int timeout;
    private final boolean verbose;
    private final ColorSetting colorSetting;
    private final boolean updateOut;
    private final boolean generateOut;
    private final String outputFile;
    private final String newOutputFile;
    private boolean success = false;
    private String reason = null;
    private long timeDelta;
    public static final int SIGTERM = 143;

    public Proc(T obj, String[] args, String procInput, Annotated<String, String> expectedOut, Annotated<String, String> expectedErr, String logStr, Comparator<String> strComparator, int timeout, boolean verbose, ColorSetting colorSetting, boolean updateOut, boolean generateOut, String outputFile, String newOutputFile) {
        this.obj = obj;
        this.args = args;
        this.expectedOut = expectedOut;
        this.expectedErr = expectedErr;
        this.logStr = logStr;
        this.procInput = procInput;
        this.strComparator = strComparator;
        this.timeout = timeout;
        this.verbose = verbose;
        this.colorSetting = colorSetting;
        this.updateOut = updateOut;
        this.generateOut = generateOut;
        this.outputFile = outputFile;
        this.newOutputFile = newOutputFile;
    }

    public Proc(T obj, String[] args, String logStr, Comparator<String> strComparator, int timeout, boolean verbose, ColorSetting colorSetting, boolean updateOut, boolean generateOut) {
        this(obj, args, "", null, null, logStr, strComparator, timeout, verbose, colorSetting, updateOut, generateOut, null, null);
    }

    @Override
    public void run() {
        ProcessBuilder pb = new ProcessBuilder(this.args);
        try {
            long startTime = System.currentTimeMillis();
            Process proc = pb.start();
            InputStream errorStream = proc.getErrorStream();
            InputStream outStream = proc.getInputStream();
            OutputStream inStream = proc.getOutputStream();
            IOUtils.write(this.procInput, inStream);
            inStream.close();
            ExecutorService service = Executors.newFixedThreadPool(2);
            Future<String> outputGobbler = service.submit(new StreamGobbler(outStream));
            Future<String> errorGobbler = service.submit(new StreamGobbler(errorStream));
            int returnCode = this.wait(proc);
            this.timeDelta = System.currentTimeMillis() - startTime;
            try {
                this.pgmOut = outputGobbler.get();
                this.pgmErr = errorGobbler.get();
            }
            catch (InterruptedException | ExecutionException e) {
                this.pgmOut = null;
                this.pgmErr = null;
            }
            this.handlePgmResult(returnCode);
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            GlobalSettings.kem.register(new KException(KException.ExceptionType.WARNING, KException.KExceptionGroup.INTERNAL, e.getMessage(), "command line", "System file."));
            this.reportErr("program failed with exception: " + e.getMessage());
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    public T getObj() {
        return this.obj;
    }

    public String getReason() {
        return this.reason;
    }

    public long getTimeDelta() {
        return this.timeDelta;
    }

    public String getPgmOut() {
        return this.pgmOut;
    }

    public String getPgmErr() {
        return this.pgmErr;
    }

    private int wait(final Process proc) throws InterruptedException {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                proc.destroy();
            }
        }, this.timeout);
        int ret = proc.waitFor();
        timer.cancel();
        return ret;
    }

    private void handlePgmResult(int returnCode) throws IOException {
        String red = ColorUtil.RgbToAnsi(Color.RED, this.colorSetting);
        if (returnCode == 0) {
            boolean doGenerateOut = false;
            if (this.expectedOut == null) {
                this.success = true;
                if (this.verbose) {
                    System.out.format("Done with [%s] (time %d ms)%n", this.logStr, this.timeDelta);
                }
                doGenerateOut = true;
            } else if (this.strComparator.compare(this.pgmOut, this.expectedOut.getObj()) != 0) {
                System.out.format("%sERROR: [%s] output doesn't match with expected output (time: %d ms)%s%n", red, this.logStr, this.timeDelta, "\u001b[0m");
                this.reportOutMatch(this.expectedOut, this.pgmOut);
                doGenerateOut = true;
            } else {
                this.success = true;
                if (this.verbose) {
                    System.out.format("Done with [%s] (time %d ms)%n", this.logStr, this.timeDelta);
                }
            }
            if (this.updateOut && this.outputFile != null) {
                IOUtils.write(this.pgmOut, (OutputStream)new FileOutputStream(new File(this.outputFile)));
                System.out.println("Updating output file: " + this.outputFile);
            }
            if (doGenerateOut && this.generateOut && this.newOutputFile != null) {
                IOUtils.write(this.pgmOut, (OutputStream)new FileOutputStream(new File(this.newOutputFile)));
                System.out.println("Generating output file: " + this.newOutputFile);
            }
        } else if (returnCode == 143) {
            System.out.format("%sERROR: [%s] killed due to timeout.%s%n", red, this.logStr, "\u001b[0m");
            this.reportTimeout();
        } else if (this.expectedErr == null) {
            System.out.format("%sERROR: [%s] failed with error (time: %d ms)%s%n", red, this.logStr, this.timeDelta, "\u001b[0m");
            if (this.verbose) {
                System.out.format("error was: %s%n", this.pgmErr);
            }
            this.reportErr(this.pgmErr);
        } else if (this.strComparator.compare(this.pgmErr, this.expectedErr.getObj()) == 0) {
            this.success = true;
            if (this.verbose) {
                System.out.format("Done with [%s] (time %d ms)%n", this.logStr, this.timeDelta);
            }
        } else {
            System.out.format("%sERROR: [%s] throwed error, but expected error message doesn't match (time: %d ms)%s%n", red, this.logStr, this.timeDelta, "\u001b[0m");
            this.reportErrMatch(this.expectedErr, this.pgmErr);
        }
    }

    private void reportErr(String err) {
        assert (this.reason == null);
        this.reason = err;
    }

    private void reportErrMatch(Annotated<String, String> expected, String found) {
        assert (this.reason == null);
        this.reason = String.format("Expected program error:%n%s%n%nbut found:%n%s%n", expected, found);
    }

    private void reportOutMatch(Annotated<String, String> expected, String found) {
        assert (this.reason == null);
        this.reason = String.format("Expected program output:%n%s%n%nbut found:%n%s%n", expected, found);
    }

    private void reportTimeout() {
        assert (this.reason == null);
        this.reason = "Timeout";
    }
}

