/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.ktest;

import java.util.HashSet;
import java.util.Set;

public class QuoteHandling {
    private static final String SINGLE_QUOTE = "'";
    private static final String DOUBLE_QUOTE = "\"";
    private static final Set<String> escapes = new HashSet<String>();

    public static String quoteArgument(String arg) {
        String cleanArg = arg.trim();
        while (cleanArg.startsWith(SINGLE_QUOTE) && cleanArg.endsWith(SINGLE_QUOTE) || cleanArg.startsWith(DOUBLE_QUOTE) && cleanArg.endsWith(DOUBLE_QUOTE)) {
            cleanArg = cleanArg.substring(1, cleanArg.length() - 1);
        }
        if (cleanArg.contains(DOUBLE_QUOTE)) {
            if (cleanArg.contains(SINGLE_QUOTE)) {
                throw new IllegalArgumentException("Can't handle single and double quotes in same argument");
            }
            return String.format("'%s'", cleanArg);
        }
        if (cleanArg.contains(SINGLE_QUOTE) || cleanArg.contains(" ")) {
            return String.format("\"%s\"", cleanArg);
        }
        for (String escape : escapes) {
            if (!cleanArg.contains(escape)) continue;
            return String.format("\"%s\"", cleanArg);
        }
        return cleanArg;
    }

    static {
        escapes.add("<");
        escapes.add(">");
    }
}

