/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.ktest;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Report {
    private final String name;
    private final boolean failed;
    private final long timeDelta;
    private final String stdout;
    private final String stderr;
    private final String errorMsg;

    private Report(String name, boolean failed, long timeDelta, String stdout, String stderr, String errorMsg) {
        this.name = name;
        this.failed = failed;
        this.timeDelta = timeDelta;
        this.stdout = stdout;
        this.stderr = stderr;
        this.errorMsg = errorMsg;
    }

    public static Report reportFailure(String name, long timeDelta, String stdout, String stderr, String errorMsg) {
        return new Report(name, true, timeDelta, stdout, stderr, errorMsg);
    }

    public static Report reportSuccess(String name, long timeDelta, String stdout, String stderr) {
        return new Report(name, false, timeDelta, stdout, stderr, null);
    }

    public Element genElement(Document doc) {
        Element testElem = doc.createElement("testcase");
        testElem.setAttribute("name", this.name);
        testElem.setAttribute("status", this.failed ? "failed" : "success");
        testElem.setAttribute("time", String.valueOf(this.timeDelta));
        Element sysout = doc.createElement("system-out");
        sysout.setTextContent(this.stdout);
        Element syserr = doc.createElement("system-err");
        syserr.setTextContent(this.stderr);
        testElem.appendChild(sysout);
        testElem.appendChild(syserr);
        if (this.failed) {
            Element error = doc.createElement("error");
            error.setAttribute("message", this.errorMsg);
            testElem.appendChild(error);
        }
        return testElem;
    }
}

