/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.ktest;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.kframework.ktest.Report;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReportGen {
    private final Map<String, List<Report>> reports = new HashMap<String, List<Report>>();

    public void addFailure(String definition, String name, long timeDelta, String stdout, String stderr, String errorMsg) {
        this.getReportLst(definition).add(Report.reportFailure(name, timeDelta, stdout, stderr, errorMsg));
    }

    public void addSuccess(String definition, String name, long timeDelta, String stdout, String stderr) {
        this.getReportLst(definition).add(Report.reportSuccess(name, timeDelta, stdout, stderr));
    }

    public void save() throws ParserConfigurationException, TransformerException, IOException {
        File junitFolder = new File("junit-reports");
        if (!junitFolder.isDirectory()) {
            junitFolder.mkdirs();
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        for (Map.Entry<String, List<Report>> e : this.reports.entrySet()) {
            Element elem = this.genElem(doc, e.getKey(), e.getValue());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(elem);
            transformer.transform(source, result);
            File targetFile = new File(junitFolder.getAbsolutePath(), FilenameUtils.getPath(e.getKey()).replaceAll(File.separator, "-") + FilenameUtils.getBaseName(e.getKey()) + ".xml");
            IOUtils.write(result.getWriter().toString(), (OutputStream)new FileOutputStream(targetFile));
        }
    }

    private Element genElem(Document doc, String name, List<Report> reports) {
        Element testSuiteElem = doc.createElement("testsuite");
        testSuiteElem.setAttribute("name", name);
        for (Report r : reports) {
            testSuiteElem.appendChild(r.genElement(doc));
        }
        return testSuiteElem;
    }

    private List<Report> getReportLst(String definition) {
        List<Report> rs = this.reports.get(definition);
        if (rs == null) {
            rs = new LinkedList<Report>();
            this.reports.put(definition, rs);
        }
        return rs;
    }
}

