/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.ktest.Test;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.kframework.ktest.Annotated;
import org.kframework.ktest.CmdArgs.CmdArg;
import org.kframework.ktest.Config.InvalidConfigError;
import org.kframework.ktest.Config.LocationData;
import org.kframework.ktest.ExecNames;
import org.kframework.ktest.KTestStep;
import org.kframework.ktest.PgmArg;
import org.kframework.ktest.QuoteHandling;
import org.kframework.ktest.Test.KRunProgram;

public class TestCase {
    private final Annotated<String, LocationData> definition;
    private final List<Annotated<String, LocationData>> programs;
    private final Set<String> extensions;
    private Set<String> excludes;
    private final List<Annotated<String, LocationData>> results;
    private List<PgmArg> kompileOpts;
    private List<PgmArg> krunOpts;
    private Map<String, List<PgmArg>> pgmSpecificKRunOpts;
    private final Set<KTestStep> skips;

    public TestCase(Annotated<String, LocationData> definition, List<Annotated<String, LocationData>> programs, String[] extensions, String[] excludes, List<Annotated<String, LocationData>> results, List<PgmArg> kompileOpts, List<PgmArg> krunOpts, Map<String, List<PgmArg>> pgmSpecificKRunOpts, Set<KTestStep> skips) throws InvalidConfigError {
        this.definition = definition;
        this.programs = programs;
        this.extensions = this.toSet(extensions);
        this.excludes = this.toSet(excludes);
        this.results = results;
        this.kompileOpts = kompileOpts;
        this.krunOpts = krunOpts;
        this.pgmSpecificKRunOpts = pgmSpecificKRunOpts;
        this.skips = skips;
    }

    public static TestCase makeTestCaseFromK(CmdArg cmdArgs) throws InvalidConfigError {
        Annotated<String, LocationData> targetFile = new Annotated<String, LocationData>(cmdArgs.getTargetFile(), new LocationData());
        LinkedList<Annotated<String, LocationData>> programs = new LinkedList<Annotated<String, LocationData>>();
        programs.add(new Annotated<String, LocationData>(cmdArgs.getResults(), new LocationData()));
        LinkedList<Annotated<String, LocationData>> results = new LinkedList<Annotated<String, LocationData>>();
        results.add(new Annotated<String, LocationData>(cmdArgs.getResults(), new LocationData()));
        ArrayList<PgmArg> emptyOpts = new ArrayList<PgmArg>(0);
        HashMap<String, List<PgmArg>> emptyOptsMap = new HashMap<String, List<PgmArg>>(0);
        return new TestCase(targetFile, programs, cmdArgs.getExtensions(), cmdArgs.getExcludes(), results, emptyOpts, emptyOpts, emptyOptsMap, new HashSet<KTestStep>());
    }

    public boolean isDefinitionKompiled() {
        return new File(FilenameUtils.concat(FilenameUtils.getFullPath(this.definition.getObj()), FilenameUtils.getBaseName(this.definition.getObj()) + "-kompiled")).isDirectory();
    }

    public List<KRunProgram> getPrograms() {
        LinkedList<KRunProgram> ret = new LinkedList<KRunProgram>();
        for (Annotated<String, LocationData> pgmDir : this.programs) {
            ret.addAll(this.searchPrograms(pgmDir.getObj()));
        }
        HashSet<String> pgmNames = new HashSet<String>();
        for (int i = ret.size() - 1; i >= 0; --i) {
            String pgmName = FilenameUtils.getName(((KRunProgram)ret.get((int)i)).pgmName);
            if (pgmNames.contains(pgmName)) {
                ret.remove(i);
                continue;
            }
            pgmNames.add(pgmName);
        }
        return ret;
    }

    public String getDefinition() {
        assert (new File(this.definition.getObj()).isFile());
        return this.definition.getObj();
    }

    public String[] getKompileCmd() {
        assert (new File(this.getDefinition()).isFile());
        String[] args = new String[this.kompileOpts.size() + 2];
        args[0] = ExecNames.getKompile();
        args[1] = this.getDefinition();
        for (int i = 0; i < this.kompileOpts.size(); ++i) {
            args[i + 2] = this.kompileOpts.get(i).toString();
        }
        return args;
    }

    public String toKompileLogString() {
        Object[] args = new String[this.kompileOpts.size() + 2];
        args[0] = ExecNames.getKompile();
        args[1] = this.getDefinition();
        for (int i = 0; i < this.kompileOpts.size(); ++i) {
            PgmArg arg = this.kompileOpts.get(i);
            args[i + 2] = new PgmArg(arg.arg, QuoteHandling.quoteArgument(arg.val)).toString();
        }
        return StringUtils.join(args, " ");
    }

    public String[] getPdfCmd() {
        assert (new File(this.getDefinition()).isFile());
        return new String[]{ExecNames.getKompile(), "--backend=pdf", this.getDefinition()};
    }

    public String toPdfLogString() {
        return StringUtils.join((Object[])this.getPdfCmd(), " ");
    }

    public void setKompileOpts(List<PgmArg> kompileOpts) {
        this.kompileOpts = kompileOpts;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = this.toSet(excludes);
    }

    public void setKrunOpts(List<PgmArg> krunOpts) {
        this.krunOpts = krunOpts;
    }

    public void setPgmSpecificKRunOpts(Map<String, List<PgmArg>> pgmSpecificKRunOpts) {
        this.pgmSpecificKRunOpts = pgmSpecificKRunOpts;
    }

    public void addProgram(Annotated<String, LocationData> program) {
        this.programs.add(program);
    }

    public void addResult(Annotated<String, LocationData> result) {
        this.results.add(result);
    }

    public boolean skip(KTestStep step) {
        return this.skips.contains((Object)step);
    }

    public void validate() throws InvalidConfigError {
        if (!new File(this.definition.getObj()).isFile()) {
            throw new InvalidConfigError("definition file " + this.definition.getObj() + " is not a file.", this.definition.getAnn());
        }
        for (Annotated<String, LocationData> p : this.programs) {
            if (new File(p.getObj()).isDirectory()) continue;
            throw new InvalidConfigError("program directory " + p.getObj() + " is not a directory.", p.getAnn());
        }
        for (Annotated<String, LocationData> r : this.results) {
            if (new File(r.getObj()).isDirectory()) continue;
            throw new InvalidConfigError("result directory " + r.getObj() + " is not a directory.", r.getAnn());
        }
    }

    private List<PgmArg> getPgmOptions(String pgm) {
        List<PgmArg> ret = this.pgmSpecificKRunOpts.get(FilenameUtils.getName(pgm));
        if (ret == null) {
            return this.krunOpts;
        }
        return ret;
    }

    private List<KRunProgram> searchPrograms(String pgmDir) {
        LinkedList<KRunProgram> ret = new LinkedList<KRunProgram>();
        File[] files = new File(pgmDir).listFiles();
        assert (files != null) : "searchPrograms returned null -- this is a bug, please report.";
        for (File pgmFile : files) {
            if (pgmFile.isFile()) {
                String pgmFilePath = pgmFile.getAbsolutePath();
                if (!this.extensions.contains(FilenameUtils.getExtension(pgmFilePath))) continue;
                boolean exclude = false;
                for (String excludedPattern : this.excludes) {
                    if (!pgmFilePath.contains(excludedPattern)) continue;
                    exclude = true;
                }
                if (exclude) continue;
                String inputFileName = FilenameUtils.getName(pgmFilePath) + ".in";
                String outputFileName = FilenameUtils.getName(pgmFilePath) + ".out";
                String errorFileName = FilenameUtils.getName(pgmFilePath) + ".err";
                String definitionFilePath = FilenameUtils.getFullPathNoEndSeparator(this.definition.getObj());
                String inputFilePath = this.searchFile(inputFileName, this.results);
                String outputFilePath = this.searchFile(outputFileName, this.results);
                String errorFilePath = this.searchFile(errorFileName, this.results);
                LinkedList<PgmArg> args = new LinkedList<PgmArg>();
                for (PgmArg arg : this.getPgmOptions(pgmFilePath)) {
                    args.add(arg);
                }
                args.add(new PgmArg("directory", definitionFilePath));
                ret.add(new KRunProgram(pgmFilePath, args, inputFilePath, outputFilePath, errorFilePath, this.getNewOutputFilePath(outputFileName)));
                continue;
            }
            ret.addAll(this.searchPrograms(pgmFile.getAbsolutePath()));
        }
        return ret;
    }

    private String getNewOutputFilePath(String outputFileName) {
        return FilenameUtils.concat(this.results.get(this.results.size() - 1).getObj(), outputFileName);
    }

    private String searchFile(String fname, List<Annotated<String, LocationData>> dirs) {
        ListIterator<Annotated<String, LocationData>> li = dirs.listIterator(dirs.size());
        while (li.hasPrevious()) {
            Annotated<String, LocationData> dir = li.previous();
            String ret = this.searchFile(fname, dir.getObj());
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private String searchFile(String fname, String dir) {
        File[] files = new File(dir).listFiles();
        assert (files != null) : "listFiles returned null -- this is a bug, please report";
        for (File f : files) {
            String ret;
            if (f.isFile() && f.getName().equals(fname)) {
                return f.getAbsolutePath();
            }
            if (!f.isDirectory() || (ret = this.searchFile(fname, f.getAbsolutePath())) == null) continue;
            return ret;
        }
        return null;
    }

    private <T> Set<T> toSet(T[] arr) {
        HashSet ret = new HashSet();
        Collections.addAll(ret, arr);
        return ret;
    }
}

