/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.ktest.Test;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.kframework.krun.ColorSetting;
import org.kframework.ktest.Annotated;
import org.kframework.ktest.CmdArgs.CmdArg;
import org.kframework.ktest.KTestStep;
import org.kframework.ktest.Proc;
import org.kframework.ktest.ReportGen;
import org.kframework.ktest.Test.KRunProgram;
import org.kframework.ktest.Test.TestCase;
import org.kframework.utils.ColorUtil;

public class TestSuite {
    private final List<TestCase> tests;
    private ThreadPoolExecutor tpe;
    private final boolean verbose;
    private final ColorSetting colorSetting;
    private final Set<KTestStep> skips;
    private final int threads;
    private final int timeout;
    private final boolean updateOut;
    private final boolean generateOut;
    private final ReportGen reportGen;
    private final Comparator<String> strComparator;
    private long kompileRealTime;
    private long kompileCPUTime;
    private long pdfRealTime;
    private long pdfCPUTime;
    private long krunRealTime;
    private long krunCPUTime;
    private int kompileSteps;
    private int pdfSteps;
    private int krunSteps;

    private TestSuite(List<TestCase> tests, Set<KTestStep> skips, int threads, boolean verbose, Comparator<String> strComparator, ColorSetting colorSetting, int timeout, boolean updateOut, boolean generateOut, boolean report) {
        this.tests = tests;
        this.skips = skips;
        this.threads = threads;
        this.verbose = verbose;
        this.strComparator = strComparator;
        this.colorSetting = colorSetting;
        this.timeout = timeout;
        this.updateOut = updateOut;
        this.generateOut = generateOut;
        this.reportGen = report ? new ReportGen() : null;
    }

    public TestSuite(List<TestCase> tests, CmdArg cmdArg) {
        this(tests, cmdArg.getSkips(), cmdArg.getThreads(), cmdArg.isVerbose(), cmdArg.getStringComparator(), cmdArg.getColorSetting(), cmdArg.getTimeout(), cmdArg.getUpdateOut(), cmdArg.getGenerateOut(), cmdArg.getGenerateReport());
    }

    public boolean run() throws InterruptedException, TransformerException, ParserConfigurationException, IOException {
        boolean ret = true;
        List<TestCase> successfulTests = this.tests;
        if (!this.skips.contains((Object)KTestStep.KOMPILE)) {
            successfulTests = this.runKompileSteps(this.filterSkips(this.tests, KTestStep.KOMPILE));
            boolean bl = ret = successfulTests.size() == this.tests.size();
        }
        if (!this.skips.contains((Object)KTestStep.PDF)) {
            ret &= this.runPDFSteps(this.filterSkips(successfulTests, KTestStep.PDF));
        }
        if (!this.skips.contains((Object)KTestStep.KRUN)) {
            ret &= this.runKRunSteps(this.filterSkips(successfulTests, KTestStep.KRUN));
        }
        String colorCode = ColorUtil.RgbToAnsi(ret ? Color.green : Color.red, this.colorSetting);
        String msg = ret ? "SUCCESS" : "FAIL (see details above)";
        System.out.format("%n%s%s%s%n", colorCode, msg, "\u001b[0m");
        this.printTimeInfo();
        if (this.reportGen != null) {
            this.reportGen.save();
        }
        return ret;
    }

    public void dryRun() {
        if (!this.skips.contains((Object)KTestStep.KOMPILE)) {
            List<TestCase> kompileSteps = this.filterSkips(this.tests, KTestStep.KOMPILE);
            for (TestCase tc : kompileSteps) {
                System.out.println(tc.toKompileLogString());
            }
        }
        if (!this.skips.contains((Object)KTestStep.PDF)) {
            List<TestCase> pdfSteps = this.filterSkips(this.tests, KTestStep.PDF);
            for (TestCase tc : pdfSteps) {
                System.out.println(tc.toPdfLogString());
            }
        }
        if (!this.skips.contains((Object)KTestStep.KRUN)) {
            List<TestCase> krunSteps = this.filterSkips(this.tests, KTestStep.KRUN);
            for (TestCase tc : krunSteps) {
                List<KRunProgram> programs = tc.getPrograms();
                for (KRunProgram program : programs) {
                    StringBuilder krunLogCmd = new StringBuilder();
                    krunLogCmd.append(program.toLogString());
                    if (program.outputFile != null) {
                        krunLogCmd.append(" >").append(program.outputFile);
                    }
                    if (program.inputFile != null) {
                        krunLogCmd.append(" <").append(program.inputFile);
                    }
                    System.out.println(krunLogCmd.toString());
                }
            }
        }
    }

    private List<TestCase> filterSkips(List<TestCase> tests, KTestStep step) {
        LinkedList<TestCase> ret = new LinkedList<TestCase>();
        for (TestCase test2 : tests) {
            if (test2.skip(step)) continue;
            ret.add(test2);
        }
        return ret;
    }

    private List<TestCase> runKompileSteps(List<TestCase> tests) throws InterruptedException {
        int len = tests.size();
        ArrayList<TestCase> successfulTests = new ArrayList<TestCase>(len);
        ArrayList<Proc<TestCase>> ps = new ArrayList<Proc<TestCase>>(len);
        System.out.format("Kompile the language definitions...(%d in total)%n", len);
        long startTime = System.currentTimeMillis();
        this.startTpe();
        for (TestCase testCase : tests) {
            Proc<TestCase> p = new Proc<TestCase>(testCase, testCase.getKompileCmd(), testCase.toKompileLogString(), this.strComparator, this.timeout, this.verbose, this.colorSetting, this.updateOut, this.generateOut);
            ps.add(p);
            this.tpe.execute(p);
            ++this.kompileSteps;
        }
        this.stopTpe();
        this.kompileRealTime += System.currentTimeMillis() - startTime;
        for (Proc proc : ps) {
            this.kompileCPUTime += proc.getTimeDelta();
            TestCase tc = (TestCase)proc.getObj();
            if (proc.isSuccess()) {
                successfulTests.add(tc);
            }
            this.makeReport(proc, this.makeRelative(tc.getDefinition()), FilenameUtils.getName(tc.getDefinition()));
        }
        this.printResult(successfulTests.size() == len);
        return successfulTests;
    }

    private boolean runPDFSteps(List<TestCase> tests) throws InterruptedException {
        ArrayList<Proc<TestCase>> ps = new ArrayList<Proc<TestCase>>();
        int len = tests.size();
        System.out.format("Generate PDF files...(%d in total)%n", len);
        this.startTpe();
        long startTime = System.currentTimeMillis();
        for (TestCase tc : tests) {
            Proc<TestCase> p = new Proc<TestCase>(tc, tc.getPdfCmd(), tc.toPdfLogString(), this.strComparator, this.timeout, this.verbose, this.colorSetting, this.updateOut, this.generateOut);
            ps.add(p);
            this.tpe.execute(p);
            ++this.pdfSteps;
        }
        this.stopTpe();
        this.pdfRealTime += System.currentTimeMillis() - startTime;
        boolean ret = true;
        for (Proc<TestCase> p : ps) {
            this.pdfCPUTime += p.getTimeDelta();
            TestCase tc = p.getObj();
            if (!p.isSuccess()) {
                ret = false;
            }
            this.makeReport(p, this.makeRelative(tc.getDefinition()), FilenameUtils.getBaseName(tc.getDefinition()) + ".pdf");
        }
        this.printResult(ret);
        return ret;
    }

    private boolean runKRunSteps(List<TestCase> tests) throws InterruptedException {
        LinkedList<TestCase> kompileSuccesses = new LinkedList<TestCase>();
        ArrayList<TestCase> notKompiled = new ArrayList<TestCase>();
        for (TestCase tc : tests) {
            if (!tc.isDefinitionKompiled()) {
                notKompiled.add(tc);
                continue;
            }
            kompileSuccesses.add(tc);
        }
        System.out.println("Kompiling definitions that are not yet kompiled.");
        kompileSuccesses.addAll(this.runKompileSteps(notKompiled));
        int successes = 0;
        int totalTests = 0;
        for (TestCase tc : kompileSuccesses) {
            List<KRunProgram> programs = tc.getPrograms();
            int inputs = 0;
            int outputs = 0;
            int errors = 0;
            for (KRunProgram p : programs) {
                if (p.inputFile != null) {
                    ++inputs;
                }
                if (p.outputFile != null) {
                    ++outputs;
                }
                if (p.errorFile == null) continue;
                ++errors;
            }
            System.out.format("Running %s programs... (%d in total, %d with input, %d with output, %d with error)%n", tc.getDefinition(), programs.size(), inputs, outputs, errors);
            ArrayList<Proc<KRunProgram>> testCaseProcs = new ArrayList<Proc<KRunProgram>>(programs.size());
            long startTime = System.currentTimeMillis();
            this.startTpe();
            for (KRunProgram kRunProgram : programs) {
                testCaseProcs.add(this.runKRun(kRunProgram));
                ++totalTests;
            }
            this.stopTpe();
            this.krunRealTime += System.currentTimeMillis() - startTime;
            for (Proc proc : testCaseProcs) {
                if (proc == null) continue;
                this.krunCPUTime += proc.getTimeDelta();
                KRunProgram pgm = (KRunProgram)proc.getObj();
                this.makeReport(proc, this.makeRelative(tc.getDefinition()), FilenameUtils.getName(pgm.pgmName));
                if (!proc.isSuccess()) continue;
                ++successes;
            }
        }
        this.printResult(successes == totalTests);
        return successes == totalTests;
    }

    private void startTpe() {
        int nThreads = this.updateOut || this.generateOut ? 1 : this.threads;
        this.tpe = (ThreadPoolExecutor)Executors.newFixedThreadPool(nThreads);
    }

    private void stopTpe() throws InterruptedException {
        this.tpe.shutdown();
        while (!this.tpe.awaitTermination(1L, TimeUnit.SECONDS)) {
        }
    }

    private Proc<KRunProgram> runKRun(KRunProgram program) {
        String[] args = program.getKrunCmd();
        String inputContents = null;
        String outputContents = null;
        String errorContents = null;
        if (program.inputFile != null) {
            try {
                inputContents = IOUtils.toString(new FileInputStream(new File(program.inputFile)));
            }
            catch (IOException e) {
                System.out.format("WARNING: cannot read input file %s -- skipping program %s%n", program.inputFile, program.args.get(1));
                return null;
            }
        }
        if (program.outputFile != null) {
            try {
                outputContents = IOUtils.toString(new FileInputStream(new File(program.outputFile)));
            }
            catch (IOException e) {
                System.out.format("WARNING: cannot read output file %s -- program output won't be matched against output file%n", program.outputFile);
            }
        }
        if (program.errorFile != null) {
            try {
                errorContents = IOUtils.toString(new FileInputStream(new File(program.errorFile)));
            }
            catch (IOException e) {
                System.out.format("WARNING: cannot read error file %s -- program error output won't be matched against error file%n", program.errorFile);
            }
        }
        Annotated<String, String> outputContentsAnn = null;
        if (outputContents != null) {
            outputContentsAnn = new Annotated<String, String>(outputContents, program.outputFile);
        }
        Annotated<String, String> errorContentsAnn = null;
        if (errorContents != null) {
            errorContentsAnn = new Annotated<String, String>(errorContents, program.errorFile);
        }
        if (this.verbose) {
            this.printVerboseRunningMsg(program);
        }
        Proc<KRunProgram> p = new Proc<KRunProgram>(program, args, inputContents, outputContentsAnn, errorContentsAnn, program.toLogString(), this.strComparator, this.timeout, this.verbose, this.colorSetting, this.updateOut, this.generateOut, program.outputFile, program.newOutputFile);
        this.tpe.execute(p);
        ++this.krunSteps;
        return p;
    }

    private void printVerboseRunningMsg(KRunProgram program) {
        StringBuilder b = new StringBuilder();
        b.append("Running [");
        b.append(program.toLogString());
        b.append("]");
        if (program.inputFile != null) {
            b.append(" [input: ");
            b.append(program.inputFile);
            b.append("]");
        }
        if (program.outputFile != null) {
            b.append(" [output: ");
            b.append(program.outputFile);
            b.append("]");
        }
        System.out.println(b);
    }

    private void printResult(boolean condition) {
        if (condition) {
            System.out.println("SUCCESS");
        } else {
            System.out.println(ColorUtil.RgbToAnsi(Color.red, this.colorSetting) + "FAIL" + "\u001b[0m");
        }
    }

    private String makeRelative(String absolutePath) {
        String pathRegex = System.getProperty("user.dir").replaceAll("\\\\", "\\\\\\\\");
        return absolutePath.replaceFirst(pathRegex, "");
    }

    private void makeReport(Proc p, String definition, String testName) {
        if (this.reportGen == null) {
            return;
        }
        if (p.isSuccess()) {
            this.reportGen.addSuccess(definition, testName, p.getTimeDelta(), p.getPgmOut(), p.getPgmErr());
        } else {
            this.reportGen.addFailure(definition, testName, p.getTimeDelta(), p.getPgmOut(), p.getPgmErr(), p.getReason());
        }
    }

    private void printTimeInfo() {
        long kompileCPUTime = this.kompileCPUTime / 1000L;
        long pdfCPUTime = this.pdfCPUTime / 1000L;
        long krunCPUTime = this.krunCPUTime / 1000L;
        long kompileRealTime = this.kompileRealTime / 1000L;
        long pdfRealTime = this.pdfRealTime / 1000L;
        long krunRealTime = this.krunRealTime / 1000L;
        String defInfo = String.format("Definitions kompiled: %s (time: %s'%s'' elapsed, %s'%s'' CPU)%n", this.kompileSteps, kompileRealTime / 60L, kompileRealTime % 60L, kompileCPUTime / 60L, kompileCPUTime % 60L);
        String pdfInfo = String.format("PDF posters kompiled: %s (time: %s'%s'' elapsed, %s'%s'' CPU)%n", this.pdfSteps, pdfRealTime / 60L, pdfRealTime % 60L, pdfCPUTime / 60L, pdfCPUTime % 60L);
        String krunInfo = String.format("Programs krun: %s (time: %s'%s'' elapsed, %s'%s'' CPU)%n", this.krunSteps, krunRealTime / 60L, krunRealTime % 60L, krunCPUTime / 60L, krunCPUTime % 60L);
        long totalRealTime = kompileRealTime + pdfRealTime + krunRealTime;
        long totalCPUTime = kompileCPUTime + pdfCPUTime + krunCPUTime;
        String totalInfo = String.format("Total time: %s'%s'' elapsed, %s'%s'' CPU%n", totalRealTime / 60L, totalRealTime % 60L, totalCPUTime / 60L, totalCPUTime % 60L);
        StringBuilder sb = new StringBuilder();
        sb.append("----------------------------\n");
        sb.append(defInfo).append(pdfInfo).append(krunInfo).append(totalInfo);
        sb.append("----------------------------\n");
        System.out.println(sb);
    }
}

