/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.main;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;

public class Kpp {
    public static void codeClean(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: kpp <filename>");
        } else {
            File f = new File(args[0]);
            if (!f.exists()) {
                System.err.println("File not found.");
            }
            try (BufferedReader input = new BufferedReader(new FileReader(f));){
                Kpp.codeClean(input, System.out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void codeClean(Reader input, OutputStream out) throws IOException {
        int ch;
        int previous = 0;
        State state = State.CODE;
        while ((ch = input.read()) != -1) {
            switch (state) {
                case SINGLE_LINE_COMMENT: {
                    if (ch != 10) break;
                    state = State.CODE;
                    previous = 0;
                    break;
                }
                case MULTI_LINE_COMMENT: {
                    if (ch != 47 || previous != 42) break;
                    state = State.CODE;
                    ch = 0;
                    previous = 0;
                    break;
                }
                case STRING: {
                    if (previous == 92 && ch == 92) {
                        out.write(previous);
                        ch = 0;
                    }
                    if (previous == 92 || ch != 34) break;
                    state = State.CODE;
                    break;
                }
                case CODE: {
                    if (ch == 34) {
                        state = State.STRING;
                        break;
                    }
                    if (previous == 47 && ch == 47) {
                        state = State.SINGLE_LINE_COMMENT;
                        break;
                    }
                    if (previous != 47 || ch != 42) break;
                    state = State.MULTI_LINE_COMMENT;
                }
            }
            if ((state == State.CODE || state == State.STRING) && previous != 0) {
                out.write(previous);
            }
            previous = ch;
        }
        if ((state == State.CODE || state == State.STRING) && previous != 0) {
            out.write(previous);
        }
        out.flush();
    }

    private static enum State {
        CODE,
        SINGLE_LINE_COMMENT,
        MULTI_LINE_COMMENT,
        STRING;

    }
}

