/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.main;

import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.kframework.kagreg.KagregFrontEnd;
import org.kframework.kast.KastFrontEnd;
import org.kframework.kcheck.KCheckFrontEnd;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.kompile.KompileFrontEnd;
import org.kframework.krun.ioserver.main.MainServer;
import org.kframework.ktest.KTest;
import org.kframework.main.KPretty;
import org.kframework.main.Kpp;
import org.kframework.utils.Error;
import org.kframework.utils.Stopwatch;
import org.kframework.utils.file.KPaths;

public class Main {
    private static void setJavaLibraryPath() {
        System.setProperty("java.library.path", KPaths.getJavaLibraryPath());
        try {
            Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
            fieldSysPath.setAccessible(true);
            fieldSysPath.set(null, null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException, TransformerException {
        Stopwatch.init();
        Main.setJavaLibraryPath();
        if (args.length >= 1) {
            String[] args2 = Arrays.copyOfRange(args, 1, args.length);
            switch (args[0]) {
                case "-kompile": {
                    KompileFrontEnd.main(args2);
                    break;
                }
                case "-kagreg": {
                    KagregFrontEnd.kagreg(args2);
                    break;
                }
                case "-kcheck": {
                    KCheckFrontEnd.kcheck(args2);
                    break;
                }
                case "-ktest": {
                    KTest.main(args2);
                    break;
                }
                case "-kast": {
                    KastFrontEnd.kast(args2);
                    break;
                }
                case "-krun": {
                    for (String s : args) {
                        if (!s.contains("debug-gui")) continue;
                        System.setProperty("java.awt.headless", "false");
                        GraphicsEnvironment.isHeadless();
                        break;
                    }
                    org.kframework.krun.Main.execute_Krun(args2);
                    break;
                }
                case "-kpp": {
                    Kpp.codeClean(args2);
                    break;
                }
                case "-ioserver": {
                    try {
                        MainServer.main(args2);
                    }
                    catch (Exception e) {
                        Error.report("IO server threw exception");
                    }
                    break;
                }
                case "-kpretty": {
                    KPretty.main(args2);
                    break;
                }
                default: {
                    Error.report("The first argument of K3 not recognized. Try -kompile, -kast, -krun or -kpp.");
                    break;
                }
            }
        } else {
            Error.report("There must be a first argument to K3: try -kompile, -kast, -krun or -kpp.");
        }
    }
}

