/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.main;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.kframework.utils.ActualPosixParser;
import org.kframework.utils.Error;

public class OptionsParser {
    Options options = new Options();
    HelpFormatter help = new HelpFormatter();

    public OptionsParser() {
        OptionGroup main = new OptionGroup();
        Option def = new Option("def", "definition", true, "main file to kompile");
        main.addOption(def);
        OptionGroup verb = new OptionGroup();
        Option help = new Option("h", "help", false, "prints this message and exits");
        Option verbose = new Option("v", "verbose", false, "verbose mode");
        verb.addOption(help);
        verb.addOption(verbose);
        OptionGroup nofile = new OptionGroup();
        Option nofileopt = new Option("nofile", "nofilename", false, "don't include the long filenames in the XML.");
        nofile.addOption(nofileopt);
        OptionGroup tex = new OptionGroup();
        Option maudify = new Option("m", "maudify", false, "maudify the definition");
        Option compile = new Option("c", "compile", false, "compile the definition");
        Option parse = new Option("kast", "kast", false, "parse a program");
        tex.addOption(compile);
        tex.addOption(maudify);
        tex.addOption(parse);
        OptionGroup tex2 = new OptionGroup();
        Option tbl = new Option("pgm", "program", true, "the program to parse");
        tex2.addOption(tbl);
        OptionGroup langGroup = new OptionGroup();
        Option lang = new Option("l", "lang", true, "start module");
        langGroup.addOption(lang);
        OptionGroup langSynGroup = new OptionGroup();
        Option langSyn = new Option("synmod", "syntax-module", true, "start module for syntax");
        langSynGroup.addOption(langSyn);
        OptionGroup libGroup = new OptionGroup();
        Option lib2 = new Option("lib", true, "Specify extra-libraries for compile/runtime.");
        libGroup.addOption(lib2);
        this.options.addOptionGroup(verb);
        this.options.addOptionGroup(main);
        this.options.addOptionGroup(langGroup);
        this.options.addOptionGroup(langSynGroup);
        this.options.addOptionGroup(tex);
        this.options.addOptionGroup(tex2);
        this.options.addOptionGroup(libGroup);
        this.options.addOptionGroup(nofile);
    }

    public CommandLine parse(String[] cmd) {
        ActualPosixParser parser = new ActualPosixParser();
        try {
            CommandLine cl = parser.parse(this.options, cmd);
            if (cl.getOptions().length > 0) {
                return cl;
            }
        }
        catch (ParseException e) {
            Error.silentReport(e.getLocalizedMessage());
            e.printStackTrace();
        }
        Error.helpExit(this.help, this.options);
        return null;
    }

    public Options getOptions() {
        return this.options;
    }

    public HelpFormatter getHelp() {
        return this.help;
    }
}

