/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.parser;

import java.io.File;
import java.io.IOException;
import org.kframework.compile.transformers.AddEmptyLists;
import org.kframework.compile.transformers.FlattenSyntax;
import org.kframework.compile.transformers.RemoveBrackets;
import org.kframework.compile.transformers.RemoveSyntacticCasts;
import org.kframework.compile.utils.CompilerStepDone;
import org.kframework.compile.utils.RuleCompilerSteps;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Cell;
import org.kframework.kil.Definition;
import org.kframework.kil.Rule;
import org.kframework.kil.Sentence;
import org.kframework.kil.Term;
import org.kframework.kil.loader.Context;
import org.kframework.kil.loader.JavaClassesFactory;
import org.kframework.kil.loader.ResolveVariableAttribute;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.parser.DefinitionLoader;
import org.kframework.parser.concrete.KParser;
import org.kframework.parser.concrete.disambiguate.AmbFilter;
import org.kframework.parser.concrete.disambiguate.PreferAvoidFilter;
import org.kframework.parser.concrete.disambiguate.PriorityFilter;
import org.kframework.parser.utils.ReportErrorsVisitor;
import org.kframework.parser.utils.Sglr;
import org.kframework.utils.BinaryLoader;
import org.kframework.utils.Stopwatch;
import org.kframework.utils.XmlLoader;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.file.FileUtil;
import org.kframework.utils.general.GlobalSettings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProgramLoader {
    public static ASTNode loadPgmAst(String content, String filename, Boolean kappize, String startSymbol, Context context) throws IOException, TransformerException {
        ASTNode out;
        File tbl = new File(context.kompiled.getCanonicalPath() + "/pgm/Program.tbl");
        if (GlobalSettings.fastKast) {
            JavaClassesFactory.startConstruction(context);
            out = Sglr.run_sglri(context.kompiled.getAbsolutePath() + "/pgm/Program.tbl", startSymbol, content, filename);
            out.accept(new ReportErrorsVisitor(context, "file"));
            JavaClassesFactory.endConstruction();
        } else {
            KParser.ImportTblPgm(tbl.getAbsolutePath());
            String parsed = KParser.ParseProgramString(content, startSymbol);
            Document doc = XmlLoader.getXMLDoc(parsed);
            XmlLoader.addFilename(doc.getFirstChild(), filename);
            XmlLoader.reportErrors(doc);
            FileUtil.save(context.kompiled.getAbsolutePath() + "/pgm.xml", parsed);
            JavaClassesFactory.startConstruction(context);
            out = JavaClassesFactory.getTerm((Element)doc.getDocumentElement().getFirstChild().getNextSibling());
            JavaClassesFactory.endConstruction();
        }
        out = out.accept(new PriorityFilter(context));
        out = out.accept(new PreferAvoidFilter(context));
        out = out.accept(new AmbFilter(context));
        out = out.accept(new RemoveBrackets(context));
        if (kappize.booleanValue()) {
            out = out.accept(new FlattenSyntax(context));
        }
        return out;
    }

    public static ASTNode loadPgmAst(String content, String filename, String startSymbol, Context context) throws IOException, TransformerException {
        return ProgramLoader.loadPgmAst(content, filename, true, startSymbol, context);
    }

    public static Term processPgm(String content, String filename, Definition def, String startSymbol, Context context, GlobalSettings.ParserType whatParser) throws TransformerException {
        Stopwatch.sw.printIntermediate("Importing Files");
        assert (context.definedSorts.contains(startSymbol)) : "The start symbol must be declared in the definition. Found: " + startSymbol;
        try {
            ASTNode out;
            if (whatParser == GlobalSettings.ParserType.GROUND) {
                KParser.ImportTblGround(context.kompiled.getCanonicalPath() + "/ground/Concrete.tbl");
                out = DefinitionLoader.parseCmdString(content, filename, startSymbol, context);
                out = out.accept(new RemoveBrackets(context));
                out = out.accept(new AddEmptyLists(context));
                out = out.accept(new RemoveSyntacticCasts(context));
                out = out.accept(new FlattenSyntax(context));
            } else if (whatParser == GlobalSettings.ParserType.RULES) {
                KParser.ImportTbl(context.kompiled.getCanonicalPath() + "/def/Concrete.tbl");
                out = DefinitionLoader.parsePattern(content, filename, startSymbol, context);
                out = out.accept(new RemoveBrackets(context));
                out = out.accept(new AddEmptyLists(context));
                out = out.accept(new RemoveSyntacticCasts(context));
                try {
                    out = new RuleCompilerSteps(def, context).compile(new Rule((Sentence)out), (String)null);
                }
                catch (CompilerStepDone e) {
                    out = (ASTNode)e.getResult();
                }
                out = ((Rule)out).getBody();
            } else if (whatParser == GlobalSettings.ParserType.BINARY) {
                out = (Cell)BinaryLoader.load(filename);
            } else {
                out = ProgramLoader.loadPgmAst(content, filename, startSymbol, context);
                out = out.accept(new ResolveVariableAttribute(context));
            }
            Stopwatch.sw.printIntermediate("Parsing Program");
            return out;
        }
        catch (IOException e) {
            String msg = "Cannot parse program: " + e.getLocalizedMessage();
            throw new TransformerException(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, filename, "File system."));
        }
    }
}

