/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.parser.basic;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Attribute;
import org.kframework.kil.Attributes;
import org.kframework.kil.DefinitionItem;
import org.kframework.kil.Import;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.Lexical;
import org.kframework.kil.LiterateComment;
import org.kframework.kil.LiterateDefinitionComment;
import org.kframework.kil.LiterateModuleComment;
import org.kframework.kil.Module;
import org.kframework.kil.PriorityBlock;
import org.kframework.kil.PriorityBlockExtended;
import org.kframework.kil.PriorityExtended;
import org.kframework.kil.PriorityExtendedAssoc;
import org.kframework.kil.Production;
import org.kframework.kil.ProductionItem;
import org.kframework.kil.Require;
import org.kframework.kil.Restrictions;
import org.kframework.kil.Sort;
import org.kframework.kil.StringSentence;
import org.kframework.kil.Syntax;
import org.kframework.kil.Terminal;
import org.kframework.kil.UserList;
import org.kframework.kil.loader.Context;
import org.kframework.parser.basic.BasicConstants;
import org.kframework.parser.basic.BasicTokenManager;
import org.kframework.parser.basic.EndPositionComparator;
import org.kframework.parser.basic.ParseException;
import org.kframework.parser.basic.SimpleCharStream;
import org.kframework.parser.basic.Token;
import org.kframework.parser.basic.TokenMgrError;
import org.kframework.utils.StringUtil;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class Basic
implements BasicConstants {
    private String filename;
    private List<DefinitionItem> items = new ArrayList<DefinitionItem>();
    private Module module = null;
    private int beginLine;
    private int beginColumn;
    private Context context;
    private static final Pattern pattern = Pattern.compile("(?s)\\s*\\[\\s*([^\\[\\]\\_\\ \\n\\r\\t]+)\\s*\\]\\s*:\\s*(.*)");
    public BasicTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[49];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static List<DefinitionItem> parse(String filename, String string, Context context) {
        Basic parser = new Basic(new StringReader(string));
        parser.filename = filename;
        parser.context = context;
        try {
            return parser.Start();
        }
        catch (ParseException e) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.PARSER, e.toString(), filename, null));
            return new ArrayList<DefinitionItem>();
        }
        catch (TokenMgrError e) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.PARSER, e.toString(), filename, null));
            return new ArrayList<DefinitionItem>();
        }
    }

    public static Attributes parseAttributes(String string, String filename) throws ParseException {
        Basic parser = new Basic(new StringReader(string));
        parser.filename = filename;
        parser.module = null;
        parser.items = new ArrayList<DefinitionItem>();
        StringSentence ss = new StringSentence("", "", "", "");
        try {
            parser.AttributesBodyEOF(ss);
        }
        catch (TokenMgrError e) {
            throw new ParseException(e.getMessage());
        }
        return ss.getAttributes();
    }

    private String startLoc() {
        Token t = this.getToken(1);
        return "(" + (this.beginLine + t.beginLine) + "," + (this.beginColumn + t.beginColumn);
    }

    private <T extends ASTNode> T markLoc(String locPrefix, T node) {
        return this.markLocExplicit(locPrefix + "," + this.token.endLine + "," + this.token.endColumn + ")", node);
    }

    private <T extends ASTNode> T markLocExplicit(String loc, T node) {
        node.setFilename(this.filename);
        node.setLocation(loc);
        return node;
    }

    private <T extends ASTNode> T tokenLoc(T node) {
        return this.markLoc("(" + (this.beginLine + this.token.beginLine) + "," + (this.beginColumn + this.token.beginColumn), node);
    }

    private String image() {
        return this.token.image;
    }

    private String special() {
        StringBuilder sb = new StringBuilder();
        Token t = this.token;
        while ((t = t.specialToken) != null) {
            sb.insert(0, t.image);
        }
        return sb.toString();
    }

    private String specialAndImage() {
        return this.special() + this.image();
    }

    private void SwitchTo(int state) {
        this.token_source.SwitchTo(state);
    }

    void comment(Token token) {
        String str = token.image;
        str = str.startsWith("//") ? str.substring(2, str.length() - 1) : str.substring(2, str.length() - 2);
        LiterateComment.LiterateCommentType lcType = LiterateComment.LiterateCommentType.COMMON;
        if (str.startsWith("@")) {
            lcType = LiterateComment.LiterateCommentType.LATEX;
            str = str.substring(1);
        } else if (str.startsWith("!")) {
            lcType = LiterateComment.LiterateCommentType.PREAMBLE;
            str = str.substring(1);
        }
        String loc = "(" + token.beginLine + "," + token.beginColumn + "," + token.endLine + "," + token.endColumn + ")";
        if (this.module == null) {
            this.items.add(this.markLocExplicit(loc, new LiterateDefinitionComment(str, lcType)));
        } else {
            this.module.appendModuleItem(this.markLocExplicit(loc, new LiterateModuleComment(str, lcType)));
        }
    }

    private StringSentence makeStringSentence(String type, String str, int sentenceBeginLine, int sentenceBeginColumn) {
        String label;
        String content;
        Matcher matcher = pattern.matcher(str);
        int offset = 0;
        if (matcher.matches()) {
            content = matcher.group(2);
            label = matcher.group(1);
            offset = matcher.start(2);
        } else {
            content = str;
            label = "";
            offset = 0;
        }
        String location = "(" + this.offsetLine(str, sentenceBeginLine, sentenceBeginColumn, offset) + "," + this.offsetColumn(str, sentenceBeginLine, sentenceBeginColumn, offset) + ")";
        int i = content.lastIndexOf(91);
        while (i >= 0) {
            Basic parser = new Basic(new StringReader(content.substring(i)));
            parser.filename = this.filename;
            parser.module = this.module;
            parser.items = this.items;
            parser.beginLine = this.offsetLine(str, sentenceBeginLine, sentenceBeginColumn, offset + i);
            parser.beginColumn = this.offsetLine(str, sentenceBeginLine, sentenceBeginColumn, offset + i);
            try {
                StringSentence ss = new StringSentence(content.substring(0, i), location, type, label);
                parser.AttributesEOF(ss);
                return ss;
            }
            catch (ParseException e) {
            }
            catch (TokenMgrError e) {
                // empty catch block
            }
            i = content.lastIndexOf(91, i - 1);
        }
        return new StringSentence(content, location, type, label);
    }

    private int offsetLine(String str, int line, int column, int index) {
        if (index == 0) {
            return line;
        }
        SimpleCharStream s = new SimpleCharStream(new StringReader(str), line, column);
        try {
            for (int i = 0; i <= index; ++i) {
                s.readChar();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        return s.getEndLine();
    }

    private int offsetColumn(String str, int line, int column, int index) {
        if (index == 0) {
            return column;
        }
        SimpleCharStream s = new SimpleCharStream(new StringReader(str), line, column);
        try {
            for (int i = 0; i <= index; ++i) {
                s.readChar();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        return s.getEndColumn();
    }

    public final void UpperId() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 38: {
                this.jj_consume_token(38);
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final String String() throws ParseException {
        this.jj_consume_token(18);
        String s = this.image();
        return StringUtil.unescape(s.substring(1, s.length() - 1));
    }

    public final Sort SimpleSortID() throws ParseException {
        String loc = this.startLoc();
        this.jj_consume_token(38);
        String str = this.image();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: {
                this.jj_consume_token(21);
                str = str + this.specialAndImage();
                this.UpperId();
                str = str + this.specialAndImage();
                this.jj_consume_token(22);
                str = str + this.specialAndImage();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        return this.markLoc(loc, new Sort(str));
    }

    public final Sort SortID() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 38: {
                Sort sort = this.SimpleSortID();
                return sort;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 33: {
                        this.jj_consume_token(33);
                        break;
                    }
                    case 34: {
                        this.jj_consume_token(34);
                        break;
                    }
                    case 35: {
                        this.jj_consume_token(35);
                        break;
                    }
                    case 36: {
                        this.jj_consume_token(36);
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return this.tokenLoc(new Sort(this.image()));
            }
        }
        this.jj_la1[3] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StringSentence Bubble(String type) throws ParseException {
        StringBuilder sb = new StringBuilder();
        this.jj_consume_token(54);
        sb.append(this.image());
        int sentenceBeginLine = this.beginLine + this.token.beginLine;
        int sentenceBeginColumn = this.beginColumn + this.token.beginColumn;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 54: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(54);
            sb.append(this.specialAndImage());
        }
        return this.makeStringSentence(type, sb.toString(), sentenceBeginLine, sentenceBeginColumn);
    }

    public final List<KLabelConstant> KLabels() throws ParseException {
        ArrayList<KLabelConstant> list = new ArrayList<KLabelConstant>();
        block3: while (true) {
            this.jj_consume_token(67);
            list.add(KLabelConstant.of(this.image(), this.context));
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 67: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[5] = this.jj_gen;
        return list;
    }

    public final String RegEx(StringBuilder follow) throws ParseException {
        StringBuilder reg = new StringBuilder();
        block3: while (true) {
            this.Element(reg, follow);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 18: 
                case 19: 
                case 21: 
                case 23: 
                case 29: 
                case 70: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[6] = this.jj_gen;
        return reg.toString();
    }

    public final void Element(StringBuilder reg, StringBuilder follow) throws ParseException {
        StringBuilder sb = new StringBuilder();
        follow.setLength(0);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                sb.append(this.specialAndImage());
                break;
            }
            case 70: {
                this.jj_consume_token(70);
                sb.append(this.specialAndImage());
                break;
            }
            case 23: 
            case 29: {
                this.Group(sb);
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                sb.append(this.specialAndImage());
                block25: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 18: 
                        case 19: 
                        case 21: 
                        case 23: 
                        case 29: 
                        case 70: {
                            break;
                        }
                        default: {
                            this.jj_la1[7] = this.jj_gen;
                            break block25;
                        }
                    }
                    this.Element(sb, follow);
                }
                this.jj_consume_token(20);
                sb.append(this.specialAndImage());
                break;
            }
            case 21: {
                this.jj_consume_token(21);
                sb.append(this.specialAndImage());
                this.Element(sb, follow);
                this.jj_consume_token(18);
                sb.append(this.specialAndImage());
                this.jj_consume_token(22);
                sb.append(this.specialAndImage());
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 26: {
                        this.jj_consume_token(26);
                        break;
                    }
                    case 27: {
                        this.jj_consume_token(27);
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                sb.append(this.specialAndImage());
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block26: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 26: 
                case 27: 
                case 28: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block26;
                }
            }
            follow.setLength(0);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 26: 
                case 27: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 26: {
                            this.jj_consume_token(26);
                            break;
                        }
                        case 27: {
                            this.jj_consume_token(27);
                            break;
                        }
                        default: {
                            this.jj_la1[11] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    follow.append((CharSequence)sb);
                    break;
                }
                case 28: {
                    this.jj_consume_token(28);
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            sb.append(this.specialAndImage());
        }
        reg.append((CharSequence)sb);
    }

    public final void Group(StringBuilder sb) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: {
                this.jj_consume_token(29);
                sb.append(this.specialAndImage());
                this.Group(sb);
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                sb.append(this.specialAndImage());
                this.SwitchTo(5);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 82: {
                        this.jj_consume_token(82);
                        sb.append(this.specialAndImage());
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                    }
                }
                this.SwitchTo(0);
                this.jj_consume_token(24);
                sb.append(this.specialAndImage());
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void AttributesEOF(ASTNode node) throws ParseException {
        this.Attributes(node);
        this.jj_consume_token(0);
    }

    public final void AttributesBodyEOF(ASTNode node) throws ParseException {
        this.SwitchTo(6);
        this.AttributesBody(node);
        this.jj_consume_token(0);
        this.SwitchTo(0);
    }

    public final void AttributesBody(ASTNode node) throws ParseException {
        this.Tag(node);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(30);
            this.Tag(node);
        }
    }

    public final void Attributes(ASTNode node) throws ParseException {
        this.jj_consume_token(23);
        this.SwitchTo(6);
        this.AttributesBody(node);
        this.jj_consume_token(24);
        this.SwitchTo(0);
    }

    public final void Tag(ASTNode node) throws ParseException {
        String loc = this.startLoc();
        String val = "";
        StringBuilder sb = new StringBuilder();
        this.jj_consume_token(93);
        String key = this.image();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                this.jj_consume_token(19);
                this.SwitchTo(7);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 18: {
                        val = this.String();
                        this.jj_consume_token(20);
                        break;
                    }
                    case 19: 
                    case 20: 
                    case 97: {
                        this.TagContent(sb);
                        this.jj_consume_token(20);
                        val = sb.toString() + this.special();
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.SwitchTo(6);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
            }
        }
        node.addAttribute(this.markLoc(loc, new Attribute(key, val)));
    }

    public final void TagContent(StringBuilder sb) throws ParseException {
        block8: {
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 19: 
                    case 97: {
                        break;
                    }
                    default: {
                        this.jj_la1[18] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 97: {
                        this.jj_consume_token(97);
                        sb.append(this.specialAndImage());
                        continue block7;
                    }
                    case 19: {
                        this.jj_consume_token(19);
                        sb.append(this.specialAndImage());
                        this.TagContent(sb);
                        this.jj_consume_token(20);
                        sb.append(this.specialAndImage());
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[19] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final List<DefinitionItem> Start() throws ParseException {
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 37: {
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    break block6;
                }
            }
            this.Require(this.items);
        }
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: {
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    break block7;
                }
            }
            this.Module(this.items);
        }
        this.jj_consume_token(0);
        return this.items;
    }

    public final void Require(List<DefinitionItem> items) throws ParseException {
        String loc = this.startLoc();
        this.jj_consume_token(37);
        String str = this.String();
        items.add(this.markLoc(loc, new Require(str)));
    }

    public final void Module(List<DefinitionItem> items) throws ParseException {
        String loc = this.startLoc();
        this.jj_consume_token(15);
        this.jj_consume_token(45);
        this.module = new Module(this.image());
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 17: {
                    break;
                }
                default: {
                    this.jj_la1[22] = this.jj_gen;
                    break block6;
                }
            }
            this.Import(this.module);
        }
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                default: {
                    this.jj_la1[23] = this.jj_gen;
                    break block7;
                }
            }
            this.Sentence(this.module);
        }
        this.jj_consume_token(10);
        Collections.sort(this.module.getItems(), new EndPositionComparator());
        items.add(this.markLoc(loc, this.module));
        this.module = null;
    }

    public final void Import(Module module) throws ParseException {
        String loc = this.startLoc();
        this.jj_consume_token(17);
        this.jj_consume_token(45);
        module.appendModuleItem(this.markLoc(loc, new Import(this.image())));
    }

    public final void Sentence(Module module) throws ParseException {
        String loc = this.startLoc();
        StringBuilder sb = new StringBuilder();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: {
                        this.jj_consume_token(6);
                        break;
                    }
                    case 7: {
                        this.jj_consume_token(7);
                        break;
                    }
                    case 8: {
                        this.jj_consume_token(8);
                        break;
                    }
                    default: {
                        this.jj_la1[24] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                String type = this.image();
                if (type.equals("configuration")) {
                    type = "config";
                }
                StringSentence ss = this.Bubble(type);
                module.appendModuleItem(this.markLoc(loc, ss));
                break;
            }
            case 9: {
                this.jj_consume_token(9);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 38: {
                        Sort sort = this.SortID();
                        Syntax syn = new Syntax(sort);
                        block15 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 23: 
                            case 98: 
                            case 99: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 98: {
                                        this.jj_consume_token(98);
                                        ArrayList<PriorityBlock> pblocks = new ArrayList<PriorityBlock>();
                                        this.PriorityBlock(pblocks);
                                        block44: while (true) {
                                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                case 25: {
                                                    break;
                                                }
                                                default: {
                                                    this.jj_la1[25] = this.jj_gen;
                                                    break block44;
                                                }
                                            }
                                            this.jj_consume_token(25);
                                            this.PriorityBlock(pblocks);
                                        }
                                        syn.setPriorityBlocks(pblocks);
                                        break block15;
                                    }
                                    case 23: {
                                        this.Attributes(syn);
                                        break block15;
                                    }
                                    case 99: {
                                        this.jj_consume_token(99);
                                        this.Group(sb);
                                        block45: while (true) {
                                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                case 100: {
                                                    break;
                                                }
                                                default: {
                                                    this.jj_la1[26] = this.jj_gen;
                                                    break block45;
                                                }
                                            }
                                            this.jj_consume_token(100);
                                            sb.append(this.specialAndImage());
                                            this.Group(sb);
                                        }
                                        module.appendModuleItem(this.markLoc(loc, new Restrictions(new Sort(syn.getSort().getRealName()), null, sb.toString())));
                                        return;
                                    }
                                }
                                this.jj_la1[27] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                            default: {
                                this.jj_la1[28] = this.jj_gen;
                            }
                        }
                        module.appendModuleItem(this.markLoc(loc, syn));
                        break block0;
                    }
                    case 12: 
                    case 13: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 12: {
                                this.jj_consume_token(12);
                                break;
                            }
                            case 13: {
                                this.jj_consume_token(13);
                                break;
                            }
                            default: {
                                this.jj_la1[29] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        ArrayList<PriorityBlockExtended> pblocks = new ArrayList<PriorityBlockExtended>();
                        List<KLabelConstant> list = this.KLabels();
                        pblocks.add(new PriorityBlockExtended(list));
                        block46: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 25: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[30] = this.jj_gen;
                                    break block46;
                                }
                            }
                            this.jj_consume_token(25);
                            list = this.KLabels();
                            pblocks.add(new PriorityBlockExtended(list));
                        }
                        module.appendModuleItem(this.markLoc(loc, new PriorityExtended(pblocks)));
                        break block0;
                    }
                    case 14: 
                    case 31: 
                    case 32: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 31: {
                                this.jj_consume_token(31);
                                break;
                            }
                            case 32: {
                                this.jj_consume_token(32);
                                break;
                            }
                            case 14: {
                                this.jj_consume_token(14);
                                break;
                            }
                            default: {
                                this.jj_la1[31] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.SwitchTo(3);
                        String type = this.image();
                        List<KLabelConstant> list = this.KLabels();
                        module.appendModuleItem(this.markLoc(loc, new PriorityExtendedAssoc(type, list)));
                        break block0;
                    }
                    case 18: {
                        String type = this.String();
                        this.jj_consume_token(99);
                        this.Group(sb);
                        block47: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 100: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[32] = this.jj_gen;
                                    break block47;
                                }
                            }
                            this.jj_consume_token(100);
                            sb.append(this.specialAndImage());
                            this.Group(sb);
                        }
                        module.appendModuleItem(this.markLoc(loc, new Restrictions(null, new Terminal(type), sb.toString())));
                        break block0;
                    }
                }
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void PriorityBlock(List<PriorityBlock> pblocks) throws ParseException {
        String loc = this.startLoc();
        String assoc = "";
        ArrayList<Production> prods = new ArrayList<Production>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 31: 
            case 32: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 31: {
                        this.jj_consume_token(31);
                        break;
                    }
                    case 32: {
                        this.jj_consume_token(32);
                        break;
                    }
                    case 14: {
                        this.jj_consume_token(14);
                        break;
                    }
                    default: {
                        this.jj_la1[35] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                assoc = this.image();
                this.jj_consume_token(101);
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
            }
        }
        this.Production(prods);
        block11: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 102: {
                    break;
                }
                default: {
                    this.jj_la1[37] = this.jj_gen;
                    break block11;
                }
            }
            this.jj_consume_token(102);
            this.Production(prods);
        }
        pblocks.add(this.markLoc(loc, new PriorityBlock(assoc, prods)));
    }

    public final void Production(List<Production> prods) throws ParseException {
        String loc = this.startLoc();
        ArrayList<ProductionItem> items = new ArrayList<ProductionItem>();
        String klabel = null;
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 38: {
                    this.UpperId();
                    break;
                }
                case 39: {
                    this.jj_consume_token(39);
                    break;
                }
                default: {
                    this.jj_la1[38] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            items.add(this.tokenLoc(new Terminal(this.image())));
            klabel = this.image();
            this.jj_consume_token(19);
            items.add(this.tokenLoc(new Terminal(this.image())));
            Sort sort = this.SortID();
            items.add(sort);
            block20: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: {
                        break;
                    }
                    default: {
                        this.jj_la1[39] = this.jj_gen;
                        break block20;
                    }
                }
                this.jj_consume_token(30);
                items.add(this.tokenLoc(new Terminal(this.image())));
                sort = this.SortID();
                items.add(sort);
            }
            this.jj_consume_token(20);
            items.add(this.tokenLoc(new Terminal(this.image())));
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: {
                    this.jj_consume_token(19);
                    items.add(this.tokenLoc(new Terminal(this.image())));
                    Sort sort = this.SortID();
                    items.add(sort);
                    block21: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 30: {
                                break;
                            }
                            default: {
                                this.jj_la1[40] = this.jj_gen;
                                break block21;
                            }
                        }
                        this.jj_consume_token(30);
                        items.add(this.tokenLoc(new Terminal(this.image())));
                        sort = this.SortID();
                        items.add(sort);
                    }
                    this.jj_consume_token(20);
                    items.add(this.tokenLoc(new Terminal(this.image())));
                    break;
                }
                case 18: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 38: {
                    block22: while (true) {
                        this.ProductionItem(items);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 18: 
                            case 33: 
                            case 34: 
                            case 35: 
                            case 36: 
                            case 38: {
                                continue block22;
                            }
                        }
                        break;
                    }
                    this.jj_la1[41] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        Production prod = new Production(new Sort(""), items);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                this.Attributes(prod);
                break;
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
            }
        }
        if (klabel != null && prod.getAttribute("klabel") == null) {
            prod.addAttribute("klabel", "'" + klabel);
        }
        prods.add(this.markLoc(loc, prod));
    }

    public final void ProductionItem(List<ProductionItem> items) throws ParseException {
        String loc = this.startLoc();
        StringBuilder follow = new StringBuilder();
        boolean isToken = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                String str = this.String();
                items.add(this.tokenLoc(new Terminal(str)));
                break;
            }
            case 38: {
                Sort sort = this.SimpleSortID();
                items.add(sort);
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        this.jj_consume_token(21);
                        this.UpperId();
                        String str = this.image();
                        this.jj_consume_token(30);
                        String sep = this.String();
                        this.jj_consume_token(22);
                        items.add(this.markLoc(loc, new UserList(str, sep, "*")));
                        return;
                    }
                }
                this.jj_la1[44] = this.jj_gen;
                items.add(this.tokenLoc(new Sort(this.image())));
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        this.jj_consume_token(21);
                        this.UpperId();
                        String str = this.image();
                        this.jj_consume_token(30);
                        String sep = this.String();
                        this.jj_consume_token(22);
                        items.add(this.markLoc(loc, new UserList(str, sep, "+")));
                        return;
                    }
                }
                this.jj_la1[45] = this.jj_gen;
                items.add(this.tokenLoc(new Sort(this.image())));
                break;
            }
            case 35: 
            case 36: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: {
                        this.jj_consume_token(35);
                        break;
                    }
                    case 36: {
                        this.jj_consume_token(36);
                        isToken = true;
                        break;
                    }
                    default: {
                        this.jj_la1[46] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        this.jj_consume_token(21);
                        this.SwitchTo(4);
                        String str = this.RegEx(follow);
                        this.jj_consume_token(22);
                        this.SwitchTo(0);
                        items.add(this.markLoc(loc, new Lexical(str + this.special(), isToken && follow.length() != 0 ? follow.toString() : null)));
                        return;
                    }
                }
                this.jj_la1[47] = this.jj_gen;
                items.add(this.tokenLoc(new Sort(this.image())));
                break;
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private boolean jj_3R_21() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(38)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(33)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(34)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(35)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(36)) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_20() {
        return this.jj_3R_21();
    }

    private boolean jj_3_1() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_20()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(39)) {
                return true;
            }
        }
        return this.jj_scan_token(19);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 0x200000, 0, 0, 0, 0, 548143104, 548143104, 0xC000000, 548143104, 0x1C000000, 0xC000000, 0x1C000000, 0, 0x20800000, 0x40000000, 0x1C0000, 524288, 524288, 524288, 0, 32768, 131072, 960, 448, 0x2000000, 0, 0x800000, 0x800000, 12288, 0x2000000, -2147467264, 0, -2147192832, 960, -2147467264, -2147467264, 0, 0, 0x40000000, 0x40000000, 262144, 786432, 0x800000, 0x200000, 0x200000, 0, 0x200000, 262144};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{94, 0, 30, 94, 0x400000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 95, 0, 1, 1, 0, 222, 0, 0, 94, 94, 0, 0, 0, 24, 0, 94};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 8, 64, 64, 0, 64, 0, 0, 0, 262144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 2, 0, 0, 0, 0, 0, 0, 16, 12, 12, 0, 0, 0, 16, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public Basic(InputStream stream) {
        this(stream, null);
    }

    public Basic(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new BasicTokenManager(this, this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 49; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 49; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public Basic(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new BasicTokenManager(this, this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 49; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 49; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public Basic(BasicTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 49; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(BasicTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 49; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[103];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 49; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 103; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 1; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        Basic.jj_la1_init_0();
        Basic.jj_la1_init_1();
        Basic.jj_la1_init_2();
        Basic.jj_la1_init_3();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

