/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.parser.concrete.disambiguate;

import java.util.ArrayList;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Ambiguity;
import org.kframework.kil.Bracket;
import org.kframework.kil.Cell;
import org.kframework.kil.Configuration;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicHookWorker;
import org.kframework.kil.visitors.BasicTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.errorsystem.KException;

public class CellTypesFilter
extends BasicTransformer {
    public CellTypesFilter(Context context) {
        super("Cell types", context);
    }

    @Override
    public ASTNode transform(Configuration cell) {
        return cell;
    }

    @Override
    public ASTNode transform(Syntax cell) {
        return cell;
    }

    @Override
    public ASTNode transform(Cell cell) throws TransformerException {
        String sort = this.context.cellKinds.get(cell.getLabel());
        if (sort == null) {
            if (cell.getLabel().equals("k")) {
                sort = "K";
            } else if (cell.getLabel().equals("T")) {
                sort = "Bag";
            } else if (cell.getLabel().equals("generatedTop")) {
                sort = "Bag";
            } else if (cell.getLabel().equals("freshCounter")) {
                sort = "K";
            } else if (cell.getLabel().equals("path-condition")) {
                sort = "K";
            }
        }
        if (sort == null) {
            String msg = "Cell '" + cell.getLabel() + "' was not declared in a configuration.";
            throw new TransformerException(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, msg, this.getName(), cell.getFilename(), cell.getLocation()));
        }
        cell.setContents((Term)cell.getContents().accept(new CellTypesFilter2(this.context, sort, cell.getLabel())));
        return super.transform(cell);
    }

    public class CellTypesFilter2
    extends BasicHookWorker {
        String expectedSort;
        String cellLabel;

        public CellTypesFilter2(Context context, String expectedSort, String cellLabel) {
            super("org.kframework.parser.concrete.disambiguate.CellTypesFilter2", context);
            this.expectedSort = expectedSort;
            this.cellLabel = cellLabel;
        }

        @Override
        public ASTNode transform(Term trm) throws TransformerException {
            if (!this.context.isSubsortedEq(this.expectedSort, trm.getSort())) {
                String msg = "Wrong type in cell '" + this.cellLabel + "'. Expected sort: " + this.expectedSort + " but found " + trm.getSort();
                throw new TransformerException(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, this.getName(), trm.getFilename(), trm.getLocation()));
            }
            return trm;
        }

        @Override
        public ASTNode transform(Bracket node) throws TransformerException {
            node.setContent((Term)node.getContent().accept(this));
            return node;
        }

        @Override
        public ASTNode transform(Rewrite node) throws TransformerException {
            Rewrite result = new Rewrite(node);
            result.replaceChildren((Term)node.getLeft().accept(this), (Term)node.getRight().accept(this), this.context);
            return result;
        }

        @Override
        public ASTNode transform(Ambiguity node) throws TransformerException {
            TransformerException exception = null;
            ArrayList<Term> terms = new ArrayList<Term>();
            for (Term t : node.getContents()) {
                ASTNode result = null;
                try {
                    result = t.accept(this);
                    terms.add((Term)result);
                }
                catch (TransformerException e) {
                    exception = e;
                }
            }
            if (terms.isEmpty()) {
                throw exception;
            }
            if (terms.size() == 1) {
                return (ASTNode)terms.get(0);
            }
            node.setContents(terms);
            return node;
        }
    }
}

