/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.parser.concrete.disambiguate;

import java.util.ArrayList;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Ambiguity;
import org.kframework.kil.KSequence;
import org.kframework.kil.MapItem;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Sort;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicTransformer;
import org.kframework.kil.visitors.exceptions.PriorityException;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.errorsystem.KException;

public class CheckBinaryPrecedenceFilter
extends BasicTransformer {
    TermCons parent = null;
    KSequence parentks = null;
    Term parentmi = null;

    public CheckBinaryPrecedenceFilter(Context context) {
        super("Check precedence for => and ~>", context);
    }

    @Override
    public ASTNode transform(Rewrite rw) throws TransformerException {
        if (this.parent != null || this.parentks != null || this.parentmi != null) {
            String msg = "Due to typing errors, rewrite is not greedy. Use parentheses to set proper scope.";
            KException kex = new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, rw.getFilename(), rw.getLocation());
            throw new PriorityException(kex);
        }
        this.parent = null;
        this.parentks = null;
        this.parentmi = null;
        return this.transform((Term)rw);
    }

    @Override
    public ASTNode transform(MapItem mi) throws TransformerException {
        this.parent = null;
        this.parentks = null;
        Term t = mi.getKey();
        this.parentmi = t instanceof Rewrite || t instanceof Ambiguity ? mi : null;
        mi.setKey((Term)t.accept(this));
        t = mi.getValue();
        this.parentmi = t instanceof Rewrite || t instanceof Ambiguity ? mi : null;
        mi.setValue((Term)t.accept(this));
        this.parentks = null;
        this.parent = null;
        this.parentmi = null;
        return this.transform((Term)mi);
    }

    @Override
    public ASTNode transform(KSequence ks) throws TransformerException {
        if (this.parent != null || this.parentks != null) {
            String msg = "Due to typing errors, ~> is not greedy. Use parentheses to set proper scope.";
            KException kex = new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, ks.getFilename(), ks.getLocation());
            throw new PriorityException(kex);
        }
        this.parent = null;
        this.parentmi = null;
        Term t = ks.getContents().get(0);
        this.parentks = t instanceof Rewrite || t instanceof Ambiguity ? ks : null;
        ks.getContents().set(0, (Term)t.accept(this));
        t = ks.getContents().get(1);
        this.parentks = t instanceof Rewrite || t instanceof Ambiguity || t instanceof KSequence ? ks : null;
        ks.getContents().set(1, (Term)t.accept(this));
        this.parentks = null;
        this.parent = null;
        this.parentmi = null;
        return this.transform((Term)ks);
    }

    @Override
    public ASTNode transform(TermCons tc) throws TransformerException {
        if (tc.getProduction().isListDecl()) {
            Term t = tc.getContents().get(0);
            this.parent = t instanceof Rewrite || t instanceof Ambiguity || t instanceof KSequence ? tc : null;
            this.parentks = null;
            this.parentmi = null;
            tc.getContents().set(0, (Term)t.accept(this));
            t = tc.getContents().get(1);
            this.parent = t instanceof Rewrite || t instanceof Ambiguity || t instanceof KSequence ? tc : null;
            this.parentks = null;
            tc.getContents().set(1, (Term)t.accept(this));
        } else if (!tc.getProduction().isConstant() && !tc.getProduction().isSubsort()) {
            int j = 0;
            for (int i = 0; i < tc.getProduction().getItems().size(); ++i) {
                if (!(tc.getProduction().getItems().get(i) instanceof Sort)) continue;
                Term t = tc.getContents().get(j);
                if ((i == 0 || i == tc.getProduction().getItems().size() - 1) && (t instanceof Rewrite || t instanceof Ambiguity || t instanceof KSequence)) {
                    this.parent = tc;
                    this.parentks = null;
                    tc.getContents().set(j, (Term)t.accept(this));
                } else {
                    this.parent = null;
                    this.parentks = null;
                    tc.getContents().set(j, (Term)t.accept(this));
                }
                ++j;
            }
        }
        return this.transform((Term)tc);
    }

    @Override
    public ASTNode transform(Ambiguity node) throws TransformerException {
        TermCons lp = this.parent;
        KSequence ks = this.parentks;
        Term mi = this.parentmi;
        TransformerException exception = null;
        ArrayList<Term> terms = new ArrayList<Term>();
        for (Term t : node.getContents()) {
            ASTNode result = null;
            try {
                if (t instanceof Rewrite || t instanceof Ambiguity || t instanceof KSequence) {
                    this.parent = lp;
                    this.parentks = ks;
                    this.parentmi = mi;
                }
                result = t.accept(this);
                terms.add((Term)result);
            }
            catch (TransformerException e) {
                exception = e;
            }
            this.parent = null;
            this.parentks = null;
            this.parentmi = null;
        }
        if (terms.isEmpty()) {
            throw exception;
        }
        if (terms.size() == 1) {
            return (ASTNode)terms.get(0);
        }
        node.setContents(terms);
        return this.transform((Term)node);
    }
}

