/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.parser.concrete.disambiguate;

import java.util.ArrayList;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Ambiguity;
import org.kframework.kil.Cast;
import org.kframework.kil.KSequence;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Sort;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicHookWorker;
import org.kframework.kil.visitors.BasicTransformer;
import org.kframework.kil.visitors.exceptions.PriorityException;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.errorsystem.KException;

public class CorrectCastPriorityFilter
extends BasicTransformer {
    private CorrectCastPriorityFilter2 secondFilter;

    public CorrectCastPriorityFilter(Context context) {
        super("Correct Cast priority", context);
        this.secondFilter = new CorrectCastPriorityFilter2(context);
    }

    @Override
    public ASTNode transform(Cast cst) throws TransformerException {
        if (cst.getContent() instanceof Variable && !((Variable)cst.getContent()).isUserTyped() && cst.getType() != Cast.CastType.OUTER) {
            Variable var = new Variable((Variable)cst.getContent());
            var.setUserTyped(true);
            var.setSort(cst.getSort());
            var.setSyntactic(cst.getType() != Cast.CastType.SEMANTIC);
            return var;
        }
        cst.getContent().accept(this.secondFilter);
        return super.transform(cst);
    }

    public class CorrectCastPriorityFilter2
    extends BasicHookWorker {
        public CorrectCastPriorityFilter2(Context context) {
            super("org.kframework.parser.concrete.disambiguate.CorrectCastPriorityFilter2", context);
        }

        @Override
        public ASTNode transform(KSequence ks) throws TransformerException {
            assert (ks.getContents().size() <= 2);
            String msg = "Due to typing errors, Casting is too greedy. Use parentheses to set proper scope.";
            KException kex = new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, ks.getFilename(), ks.getLocation());
            throw new PriorityException(kex);
        }

        @Override
        public ASTNode transform(Rewrite ks) throws TransformerException {
            String msg = "Due to typing errors, Casting is too greedy. Use parentheses to set proper scope.";
            KException kex = new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, ks.getFilename(), ks.getLocation());
            throw new PriorityException(kex);
        }

        @Override
        public ASTNode transform(TermCons tc) throws TransformerException {
            assert (tc.getProduction() != null) : this.getClass() + ":" + " cons not found." + tc.getCons();
            int lastElement = tc.getProduction().getItems().size() - 1;
            if (tc.getProduction().getItems().get(lastElement) instanceof Sort || tc.getProduction().isListDecl()) {
                String msg = "Due to typing errors, Casting is too greedy. Use parentheses to set proper scope.";
                KException kex = new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, tc.getFilename(), tc.getLocation());
                throw new PriorityException(kex);
            }
            return super.transform(tc);
        }

        @Override
        public ASTNode transform(Ambiguity node) throws TransformerException {
            TransformerException exception = null;
            ArrayList<Term> terms = new ArrayList<Term>();
            for (Term t : node.getContents()) {
                ASTNode result = null;
                try {
                    result = t.accept(this);
                    terms.add((Term)result);
                }
                catch (TransformerException e) {
                    exception = e;
                }
            }
            if (terms.isEmpty()) {
                throw exception;
            }
            if (terms.size() == 1) {
                return (ASTNode)terms.get(0);
            }
            node.setContents(terms);
            return node;
        }
    }
}

