/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.parser.concrete.disambiguate;

import org.kframework.kil.Ambiguity;
import org.kframework.kil.Bracket;
import org.kframework.kil.Collection;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Sort;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.UserList;
import org.kframework.kil.loader.Context;
import org.kframework.parser.concrete.disambiguate.GetFitnessUnitBasicVisitor;

public class GetFitnessUnitTypeCheckVisitor
extends GetFitnessUnitBasicVisitor {
    public GetFitnessUnitTypeCheckVisitor(Context context) {
        super(context);
    }

    @Override
    public void visit(TermCons tc) {
        super.visit(tc);
        if (tc.getProduction().getItems().get(0) instanceof UserList) {
            UserList ulist = (UserList)tc.getProduction().getItems().get(0);
            this.score += this.getFitnessUnit2(ulist.getSort(), tc.getContents().get(0));
            this.score += this.getFitnessUnit2(tc.getProduction().getSort(), tc.getContents().get(1));
        } else {
            int j = 0;
            for (int i = 0; i < tc.getProduction().getItems().size(); ++i) {
                if (!(tc.getProduction().getItems().get(i) instanceof Sort)) continue;
                Sort sort = (Sort)tc.getProduction().getItems().get(i);
                Term child = tc.getContents().get(j);
                this.score += this.getFitnessUnit2(sort.getName(), child);
                ++j;
            }
        }
    }

    @Override
    public void visit(Collection node) {
        super.visit(node);
        for (Term t : node.getContents()) {
            if (this.context.isSubsortedEq(node.getSort(), t.getSort())) continue;
            this.score += -1;
        }
    }

    private int getFitnessUnit2(String declSort, Term childTerm) {
        if (childTerm instanceof Rewrite) {
            Rewrite rw = (Rewrite)childTerm;
            return this.getFitnessUnit2(declSort, rw.getLeft()) + this.getFitnessUnit2(declSort, rw.getRight());
        }
        if (childTerm instanceof Ambiguity) {
            return 0;
        }
        if (childTerm instanceof Bracket) {
            Bracket br = (Bracket)childTerm;
            return this.getFitnessUnit2(declSort, br.getContent());
        }
        return this.getFitnessUnit3(declSort, childTerm.getSort());
    }

    private int getFitnessUnit3(String declSort, String termSort) {
        int score = this.context.isSubsortedEq(declSort, termSort) ? 0 : (this.context.isSubsortedEq("K", termSort) && (declSort.equals("K") || termSort.equals("K")) ? 0 : -1);
        return score;
    }

    @Override
    public GetFitnessUnitBasicVisitor getInstance() {
        return new GetFitnessUnitTypeCheckVisitor(this.context);
    }
}

