/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.parser.concrete.disambiguate;

import org.kframework.kil.ASTNode;
import org.kframework.kil.TermCons;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicTransformer;
import org.kframework.kil.visitors.exceptions.PriorityException;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.errorsystem.KException;

public class InclusionFilter
extends BasicTransformer {
    String localModule = null;

    public InclusionFilter(String localModule, Context context) {
        super("Inclusion filter", context);
        this.localModule = localModule;
    }

    @Override
    public ASTNode transform(TermCons tc) throws TransformerException {
        String consFile = tc.getProduction().getFilename();
        String consModule = tc.getProduction().getOwnerModuleName();
        if (!this.context.isModuleIncludedEq(this.localModule, consModule)) {
            String msg = "Production " + tc.getProduction().toString() + " has not been imported in this module.\n";
            msg = msg + "    Defined in module: " + consModule + " file: " + consFile;
            KException kex = new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, tc.getFilename(), tc.getLocation());
            throw new PriorityException(kex);
        }
        return super.transform(tc);
    }
}

