/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.parser.concrete.disambiguate;

import java.util.ArrayList;
import java.util.HashSet;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Ambiguity;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class MergeAmbFilter
extends BasicTransformer {
    public MergeAmbFilter(Context context) {
        super("Remove ambiguity duplicates", context);
    }

    @Override
    public ASTNode transform(Ambiguity amb) throws TransformerException {
        ArrayList<Term> children = new ArrayList<Term>();
        for (int i = 0; i < amb.getContents().size(); ++i) {
            children.add(amb.getContents().get(i));
        }
        ArrayList<Term> newchildren = new ArrayList<Term>();
        while (!children.isEmpty()) {
            Term head = (Term)children.get(0);
            ArrayList<Term> similar = new ArrayList<Term>();
            similar.add(head);
            for (int i = 1; i < children.size(); ++i) {
                if (!this.isSimilar(head, (Term)children.get(i))) continue;
                similar.add((Term)children.get(i));
            }
            children.removeAll(similar);
            if (similar.size() > 1) {
                TermCons tcnew = new TermCons((TermCons)head);
                tcnew.getContents().clear();
                for (int i = 0; i < tcnew.arity(); ++i) {
                    HashSet<Term> list2 = new HashSet<Term>();
                    for (int j = 0; j < similar.size(); ++j) {
                        list2.add(((TermCons)similar.get(j)).getContents().get(i));
                    }
                    if (list2.size() > 1) {
                        Ambiguity amb2 = new Ambiguity("K", new ArrayList<Term>(list2));
                        amb2.setLocation(tcnew.getLocation());
                        amb2.setFilename(tcnew.getFilename());
                        tcnew.getContents().add(amb2);
                        continue;
                    }
                    tcnew.getContents().add((Term)list2.iterator().next());
                }
                newchildren.add(tcnew);
                continue;
            }
            newchildren.add((Term)similar.get(0));
        }
        if (newchildren.size() > 1) {
            Ambiguity amb2 = new Ambiguity("K", newchildren);
            amb2.setLocation(amb.getLocation());
            amb2.setFilename(amb.getFilename());
            return super.transform(amb2);
        }
        return ((Term)newchildren.get(0)).accept(this);
    }

    private boolean isSimilar(Term t1, Term t2) {
        if (!t1.getClass().equals(t2.getClass())) {
            return false;
        }
        if (t1 instanceof TermCons) {
            if (!((TermCons)t1).getCons().equals(((TermCons)t2).getCons())) {
                return false;
            }
            TermCons tc1 = (TermCons)t1;
            TermCons tc2 = (TermCons)t2;
            for (int i = 0; i < tc1.getContents().size(); ++i) {
                String loc1 = tc1.getContents().get(i).getLocation();
                String loc2 = tc2.getContents().get(i).getLocation();
                if (loc1.toString().equals(loc2.toString())) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

