/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.parser.concrete.disambiguate;

import org.kframework.kil.ASTNode;
import org.kframework.kil.Configuration;
import org.kframework.kil.Context;
import org.kframework.kil.Rule;
import org.kframework.kil.Syntax;
import org.kframework.kil.TermCons;
import org.kframework.kil.Variable;
import org.kframework.kil.visitors.BasicTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.kil.visitors.exceptions.VariableTypeClashException;
import org.kframework.utils.errorsystem.KException;

public class SentenceVariablesFilter
extends BasicTransformer {
    private boolean config = false;

    public SentenceVariablesFilter(org.kframework.kil.loader.Context context) {
        super("Sentence Variable Filter", context);
    }

    @Override
    public ASTNode transform(Configuration cfg) throws TransformerException {
        this.config = true;
        return super.transform(cfg);
    }

    @Override
    public ASTNode transform(Context cfg) throws TransformerException {
        this.config = false;
        return super.transform(cfg);
    }

    @Override
    public ASTNode transform(Rule cfg) throws TransformerException {
        this.config = false;
        return super.transform(cfg);
    }

    @Override
    public ASTNode transform(Syntax cfg) throws TransformerException {
        this.config = false;
        return cfg;
    }

    @Override
    public ASTNode transform(TermCons tc) throws TransformerException {
        super.transform(tc);
        if (tc.getProduction().isSubsort() && tc.getContents().get(0) instanceof Variable) {
            return tc.getContents().get(0);
        }
        return tc;
    }

    @Override
    public ASTNode transform(Variable var) throws TransformerException {
        if (this.config) {
            if (!var.getName().startsWith("$")) {
                String msg = "In the configuration you can only have external variables, not: '" + var.getName() + "' (starts with '$').";
                KException kex = new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, var.getFilename(), var.getLocation());
                throw new VariableTypeClashException(kex);
            }
        } else if (var.getName().startsWith("$")) {
            String msg = "You can have external variables only in the configuration: '" + var.getName() + "' (starts with '$').";
            KException kex = new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, var.getFilename(), var.getLocation());
            throw new VariableTypeClashException(kex);
        }
        return var;
    }
}

