/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.parser.concrete.disambiguate;

import java.util.ArrayList;
import java.util.HashSet;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Ambiguity;
import org.kframework.kil.Lexical;
import org.kframework.kil.Production;
import org.kframework.kil.ProductionItem;
import org.kframework.kil.Sort;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.Terminal;
import org.kframework.kil.UserList;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class TypeInferenceSupremumFilter
extends BasicTransformer {
    public TypeInferenceSupremumFilter(Context context) {
        super("Type inference supremum", context);
    }

    @Override
    public ASTNode transform(Ambiguity amb) throws TransformerException {
        HashSet<Term> processed = new HashSet<Term>();
        HashSet<Term> maxterms = new HashSet<Term>();
        for (Term t : amb.getContents()) {
            if (processed.contains(t)) continue;
            processed.add(t);
            HashSet<Term> group = new HashSet<Term>();
            group.add(t);
            for (Term t2 : amb.getContents()) {
                if (processed.contains(t2) || !this.termsAlike_simple(t, t2)) continue;
                processed.add(t2);
                group.add(t2);
            }
            if (t instanceof TermCons) {
                for (Term tm2 : group) {
                    boolean min = true;
                    Production tcBig = ((TermCons)tm2).getProduction();
                    for (Term tm22 : group) {
                        Production tcSmall = ((TermCons)tm22).getProduction();
                        if (tm2 == tm22 || !this.isSubsorted(tcBig, tcSmall)) continue;
                        min = false;
                        break;
                    }
                    if (!min) continue;
                    maxterms.add(tm2);
                }
                continue;
            }
            if (t instanceof Variable) {
                for (Term t1 : group) {
                    boolean max = true;
                    for (Term t2 : group) {
                        if (t1 == t2 || !this.context.isSubsorted(t2.getSort(), t1.getSort())) continue;
                        max = false;
                    }
                    if (!max) continue;
                    maxterms.add(t1);
                }
                continue;
            }
            maxterms.addAll(group);
        }
        if (maxterms.size() == 1) {
            return ((Term)maxterms.iterator().next()).accept(this);
        }
        if (maxterms.size() > 1) {
            amb.setContents(new ArrayList<Term>(maxterms));
        }
        return super.transform(amb);
    }

    private boolean isSubsorted(Production big, Production small) {
        if (big == small) {
            return false;
        }
        if (big.getItems().size() != small.getItems().size()) {
            return false;
        }
        if (!this.context.isSubsortedEq(big.getSort(), small.getSort())) {
            return false;
        }
        for (int i = 0; i < big.getItems().size(); ++i) {
            String smallSort;
            String bigSort;
            if (!(big.getItems().get(i) instanceof Terminal && small.getItems().get(i) instanceof Terminal || big.getItems().get(i) instanceof Sort && small.getItems().get(i) instanceof Sort || big.getItems().get(i) instanceof UserList && small.getItems().get(i) instanceof UserList || big.getItems().get(i) instanceof Lexical && small.getItems().get(i) instanceof Lexical)) {
                return false;
            }
            if (!(big.getItems().get(i) instanceof Sort ? !this.context.isSubsortedEq(bigSort = ((Sort)big.getItems().get(i)).getName(), smallSort = ((Sort)small.getItems().get(i)).getName()) : big.getItems().get(i) instanceof UserList && !this.context.isSubsortedEq(bigSort = ((UserList)big.getItems().get(i)).getSort(), smallSort = ((UserList)small.getItems().get(i)).getSort()))) continue;
            return false;
        }
        return true;
    }

    private boolean termsAlike_simple(Term trm1, Term trm2) {
        if (!trm1.getClass().equals(trm2.getClass())) {
            return false;
        }
        if (trm1 instanceof TermCons) {
            TermCons term1 = (TermCons)trm1;
            TermCons term2 = (TermCons)trm2;
            if (term1.getProduction().getItems().size() != term2.getProduction().getItems().size()) {
                return false;
            }
            if (!term1.getProduction().getKLabel().equals(term2.getProduction().getKLabel())) {
                return false;
            }
            for (int i = 0; i < term1.getProduction().getItems().size(); ++i) {
                ProductionItem itm1 = term1.getProduction().getItems().get(i);
                ProductionItem itm2 = term2.getProduction().getItems().get(i);
                if (itm1 instanceof Terminal && !itm1.equals(itm2)) {
                    return false;
                }
                if (itm1 instanceof UserList) {
                    if (!(itm2 instanceof UserList)) {
                        return false;
                    }
                    UserList ul1 = (UserList)itm1;
                    UserList ul2 = (UserList)itm2;
                    if (ul1.getSeparator().equals(ul2.getSeparator())) continue;
                    return false;
                }
                if (!(itm1 instanceof Sort) || itm2 instanceof Sort) continue;
                return false;
            }
        }
        return true;
    }
}

