/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.parser.concrete.disambiguate;

import java.util.ArrayList;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Ambiguity;
import org.kframework.kil.Bracket;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Term;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicHookWorker;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.errorsystem.KException;

public class TypeSystemFilter2
extends BasicHookWorker {
    private String maxSort;

    public TypeSystemFilter2(String maxSort, Context context) {
        super("Type system", context);
        this.maxSort = maxSort;
    }

    public TypeSystemFilter2(TypeSystemFilter2 tsf, Context context) {
        super("Type system", context);
        this.maxSort = tsf.maxSort;
    }

    @Override
    public ASTNode transform(Term trm) throws TransformerException {
        if (!(trm.getSort().equals("K") || trm.getSort().equals("KItem") || trm.getSort().equals("KResult") || this.context.isSubsortedEq(this.maxSort, trm.getSort()))) {
            KException kex = new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "type error: unexpected term '" + trm + "' of sort '" + trm.getSort() + "', expected sort '" + this.maxSort + "'.", trm.getFilename(), trm.getLocation());
            throw new TransformerException(kex);
        }
        return trm;
    }

    @Override
    public ASTNode transform(Ambiguity node) throws TransformerException {
        TransformerException exception = null;
        ArrayList<Term> terms = new ArrayList<Term>();
        for (Term t : node.getContents()) {
            ASTNode result = null;
            try {
                result = t.accept(this);
                terms.add((Term)result);
            }
            catch (TransformerException e) {
                exception = e;
            }
        }
        if (terms.isEmpty()) {
            throw exception;
        }
        if (terms.size() == 1) {
            return (ASTNode)terms.get(0);
        }
        node.setContents(terms);
        return node;
    }

    @Override
    public ASTNode transform(Bracket node) throws TransformerException {
        node.setContent((Term)node.getContent().accept(this));
        return node;
    }

    @Override
    public ASTNode transform(Rewrite node) throws TransformerException {
        Rewrite result = new Rewrite(node);
        result.replaceChildren((Term)node.getLeft().accept(this), (Term)node.getRight().accept(this), this.context);
        return result;
    }
}

