/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.parser.concrete.disambiguate;

import java.util.Map;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.kil.visitors.exceptions.VariableTypeClashException;
import org.kframework.utils.errorsystem.KException;

public class VariableTypeFilter
extends BasicTransformer {
    private Map<String, Variable> variableTypes = null;
    private boolean expected = false;

    public VariableTypeFilter(Map<String, Variable> types, boolean expected, Context context) {
        super("Variable type filter", context);
        this.variableTypes = types;
        this.expected = expected;
    }

    @Override
    public ASTNode transform(Variable r) throws TransformerException {
        Variable correctVar = this.variableTypes.get(r.getName());
        if (correctVar == null) {
            return r;
        }
        assert (r.getExpectedSort() != null) : "Expected sort Should not be null";
        if (!this.expected && this.context.isSubsortedEq(r.getSort(), correctVar.getSort()) || this.expected && this.context.isSubsortedEq(r.getExpectedSort(), correctVar.getExpectedSort())) {
            Variable newV = new Variable(r);
            if (!this.expected) {
                newV.setSort(correctVar.getSort());
            }
            newV.setExpectedSort(correctVar.getExpectedSort());
            newV.setSyntactic(correctVar.isSyntactic());
            newV.setUserTyped(correctVar.isUserTyped());
            return newV;
        }
        String msg = "Variable " + r.getName() + " is contextually expected to have sort " + r.getExpectedSort();
        msg = msg + " but it has been declared (or infered) of sort " + correctVar.getExpectedSort() + ".";
        KException kex = new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, r.getFilename(), r.getLocation());
        throw new VariableTypeClashException(kex);
    }
}

