/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.parser.concrete.disambiguate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Ambiguity;
import org.kframework.kil.Sentence;
import org.kframework.kil.Term;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicTransformer;
import org.kframework.kil.visitors.BasicVisitor;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.parser.concrete.disambiguate.CollectExpectedVariablesVisitor;
import org.kframework.parser.concrete.disambiguate.CollectVariablesVisitor;
import org.kframework.parser.concrete.disambiguate.TypeInferenceSupremumFilter;
import org.kframework.parser.concrete.disambiguate.TypeSystemFilter;
import org.kframework.parser.concrete.disambiguate.VarHashMap;
import org.kframework.parser.concrete.disambiguate.VariableTypeFilter;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class VariableTypeInferenceFilter
extends BasicTransformer {
    public VariableTypeInferenceFilter(Context context) {
        super("Variable type inference", context);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ASTNode transform(Sentence r) throws TransformerException {
        r = (Sentence)r.accept(new RemoveDuplicateVariables(this.context));
        CollectVariablesVisitor vars = new CollectVariablesVisitor(this.context);
        r.accept(vars);
        HashMap<String, Variable> varDeclMap = new HashMap<String, Variable>();
        for (Map.Entry<String, List<Variable>> varEntry : vars.getVars().entrySet()) {
            Variable var;
            List<Variable> varList = varEntry.getValue();
            if (varList.size() > 1) {
                for (Variable v1 : varList) {
                    for (Variable v2 : varList) {
                        if (v1 == v2 || v1.getSort().equals(v2.getSort())) continue;
                        String string = "Variable '" + v1.getName() + "' declared with two different sorts: " + v1.getSort() + " and " + v2.getSort();
                        throw new TransformerException(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, string, this.getName(), v1.getFilename(), v1.getLocation()));
                    }
                    if (v1.isSyntactic()) continue;
                    varDeclMap.put(v1.getName(), v1);
                }
            }
            if (varDeclMap.containsKey((var = varList.iterator().next()).getName())) continue;
            varDeclMap.put(var.getName(), var);
        }
        try {
            r = (Sentence)r.accept(new VariableTypeFilter(varDeclMap, false, this.context));
            r = (Sentence)r.accept(new TypeSystemFilter(this.context));
            r = (Sentence)r.accept(new TypeInferenceSupremumFilter(this.context));
        }
        catch (TransformerException e) {
            e.report();
        }
        boolean varTypeInference = true;
        if (varTypeInference) {
            CollectExpectedVariablesVisitor vars2 = new CollectExpectedVariablesVisitor(this.context);
            r.accept(vars2);
            HashSet<VarHashMap> solutions = new HashSet<VarHashMap>();
            String fails = null;
            HashSet<String> failsAmb = null;
            String failsAmbName = null;
            for (VarHashMap varHashMap : vars2.vars) {
                VarHashMap varHashMap2 = new VarHashMap();
                for (Map.Entry entry : varHashMap.entrySet()) {
                    HashSet<String> mins = new HashSet<String>();
                    for (String string : this.context.definedSorts) {
                        boolean min = true;
                        for (String var : (Set)entry.getValue()) {
                            if (this.context.isSubsortedEq(var, string)) continue;
                            min = false;
                            break;
                        }
                        if (!min) continue;
                        mins.add(string);
                    }
                    if (mins.size() == 0) {
                        fails = (String)entry.getKey();
                        varHashMap2.clear();
                        break;
                    }
                    if (mins.size() > 1) {
                        HashSet<String> hashSet = new HashSet<String>();
                        for (String vv1 : mins) {
                            boolean maxSort = true;
                            for (String vv2 : mins) {
                                if (!this.context.isSubsorted(vv2, vv1)) continue;
                                maxSort = false;
                            }
                            if (!maxSort) continue;
                            hashSet.add(vv1);
                        }
                        if (hashSet.size() == 1) {
                            varHashMap2.put(entry.getKey(), hashSet);
                            continue;
                        }
                        failsAmb = hashSet;
                        failsAmbName = (String)entry.getKey();
                        varHashMap2.clear();
                        break;
                    }
                    varHashMap2.put(entry.getKey(), mins);
                }
                if (varHashMap2.isEmpty()) continue;
                solutions.add(varHashMap2);
            }
            if (!vars2.vars.isEmpty()) {
                if (solutions.size() == 0) {
                    String msg;
                    if (fails != null) {
                        msg = "Could not infer a sort for variable '" + fails + "' to match every location.";
                        throw new TransformerException(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, r.getFilename(), r.getLocation()));
                    }
                    msg = "Could not infer a unique sort for variable '" + failsAmbName + "'.";
                    msg = msg + " Possible sorts: ";
                    for (String string : failsAmb) {
                        msg = msg + string + ", ";
                    }
                    msg = msg.substring(0, msg.length() - 2);
                    throw new TransformerException(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, r.getFilename(), r.getLocation()));
                }
                if (solutions.size() == 1) {
                    for (Map.Entry entry : ((VarHashMap)solutions.iterator().next()).entrySet()) {
                        Variable variable = new Variable((String)entry.getKey(), null);
                        variable.setUserTyped(false);
                        variable.setExpectedSort((String)((Set)entry.getValue()).iterator().next());
                        variable.setSyntactic(false);
                        varDeclMap.put((String)entry.getKey(), variable);
                    }
                    try {
                        r = (Sentence)r.accept(new VariableTypeFilter(varDeclMap, true, this.context));
                    }
                    catch (TransformerException e) {
                        e.report();
                    }
                    CollectRemainingVarsVisitor vars3 = new CollectRemainingVarsVisitor(this.context);
                    r.accept(vars3);
                    varDeclMap.clear();
                    for (Map.Entry<String, List<Variable>> entry : vars3.vars.entrySet()) {
                        List<Variable> varList = entry.getValue();
                        HashMap varLoc = new HashMap();
                        for (Variable variable : varList) {
                            if (varLoc.containsKey(variable.getLocation())) {
                                ((Set)varLoc.get(variable.getLocation())).add(variable);
                                continue;
                            }
                            HashSet<Variable> hashSet = new HashSet<Variable>();
                            hashSet.add(variable);
                            varLoc.put(variable.getLocation(), hashSet);
                        }
                        for (Map.Entry entry2 : varLoc.entrySet()) {
                            void var17_53;
                            Variable variable = (Variable)((Set)entry2.getValue()).iterator().next();
                            for (Variable vv1 : (Set)entry2.getValue()) {
                                if (!this.context.isSubsorted(vv1.getSort(), var17_53.getSort())) continue;
                                Variable variable2 = vv1;
                            }
                            ((Set)entry2.getValue()).clear();
                            ((Set)entry2.getValue()).add(var17_53);
                        }
                        Variable vmin = (Variable)((Set)varLoc.entrySet().iterator().next().getValue()).iterator().next();
                        for (Map.Entry entry3 : varLoc.entrySet()) {
                            Variable vloc = (Variable)((Set)entry3.getValue()).iterator().next();
                            if (!this.context.isSubsorted(vmin.getSort(), vloc.getSort())) continue;
                            vmin = vloc;
                        }
                        varDeclMap.put(vmin.getName(), vmin);
                        String string = "Variable '" + vmin.getName() + "' was not declared. Assuming sort " + vmin.getSort() + " and expected sort " + vmin.getExpectedSort() + ".";
                        GlobalSettings.kem.register(new KException(KException.ExceptionType.HIDDENWARNING, KException.KExceptionGroup.COMPILER, string, vmin.getFilename(), vmin.getLocation()));
                    }
                    if (!varDeclMap.isEmpty()) {
                        try {
                            r = (Sentence)r.accept(new VariableTypeFilter(varDeclMap, false, this.context));
                        }
                        catch (TransformerException transformerException) {
                            transformerException.report();
                        }
                    }
                } else {
                    HashMap collect = new HashMap();
                    for (VarHashMap varHashMap : solutions) {
                        for (Map.Entry s : varHashMap.entrySet()) {
                            if (collect.containsKey(s.getKey())) {
                                ((Set)collect.get(s.getKey())).addAll((Collection)s.getValue());
                                continue;
                            }
                            collect.put(s.getKey(), new HashSet((Collection)s.getValue()));
                        }
                    }
                    for (Map.Entry entry : collect.entrySet()) {
                        if (((Set)entry.getValue()).size() <= 1) continue;
                        String msg = "Could not infer a unique sort for variable '" + (String)entry.getKey() + "'.";
                        msg = msg + " Possible sorts: ";
                        for (String vv1 : (Set)entry.getValue()) {
                            msg = msg + vv1 + ", ";
                        }
                        msg = msg.substring(0, msg.length() - 2);
                        throw new TransformerException(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, r.getFilename(), r.getLocation()));
                    }
                    assert (false) : "An error message should have been thrown here in the above loop.";
                }
            }
        }
        return r;
    }

    public class CollectRemainingVarsVisitor
    extends BasicVisitor {
        public Map<String, List<Variable>> vars;

        public CollectRemainingVarsVisitor(Context context) {
            super(context);
            this.vars = new HashMap<String, List<Variable>>();
        }

        @Override
        public void visit(Variable var) {
            if (!var.getName().equals("_") && !var.isUserTyped()) {
                if (this.vars.containsKey(var.getName())) {
                    this.vars.get(var.getName()).add(var);
                } else {
                    ArrayList<Variable> varss = new ArrayList<Variable>();
                    varss.add(var);
                    this.vars.put(var.getName(), varss);
                }
            }
        }
    }

    public class RemoveDuplicateVariables
    extends BasicTransformer {
        public RemoveDuplicateVariables(Context context) {
            super(RemoveDuplicateVariables.class.toString(), context);
        }

        @Override
        public ASTNode transform(Ambiguity amb) throws TransformerException {
            HashSet<Term> maxterms = new HashSet<Term>();
            for (Term t : amb.getContents()) {
                if (t instanceof Variable) {
                    boolean max = true;
                    for (Term t1 : amb.getContents()) {
                        if (t1 == t || !(t1 instanceof Variable) || !this.context.isSubsorted(t1.getSort(), t.getSort())) continue;
                        max = false;
                        break;
                    }
                    if (!max) continue;
                    maxterms.add(t);
                    continue;
                }
                maxterms.add(t);
            }
            if (maxterms.size() == 1) {
                return ((Term)maxterms.iterator().next()).accept(this);
            }
            if (maxterms.size() > 1) {
                amb.setContents(new ArrayList<Term>(maxterms));
            }
            return super.transform(amb);
        }
    }
}

