/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.parser.concrete2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kframework.kil.Ambiguity;
import org.kframework.kil.KList;
import org.kframework.kil.Term;
import org.kframework.kil.Token;
import org.kframework.parser.concrete2.Function;

public class Grammar {

    public static class RegExState
    extends PrimitiveState {
        private final Pattern pattern;

        public RegExState(StateId stateId, NonTerminal nt, State.OrderingInfo orderingInfo, Pattern pattern) {
            super(stateId, nt, orderingInfo);
            this.pattern = pattern;
        }

        @Override
        Set<PrimitiveState.MatchResult> matches(CharSequence text, int startPosition, Function context) {
            Matcher matcher = this.pattern.matcher(text);
            matcher.region(startPosition, text.length());
            matcher.useAnchoringBounds(false);
            matcher.useAnchoringBounds(false);
            HashSet<PrimitiveState.MatchResult> results = new HashSet<PrimitiveState.MatchResult>();
            if (matcher.lookingAt()) {
                results.add(new PrimitiveState.MatchResult(matcher.end(), Function.constant(Token.kAppOf("K", matcher.group()))));
            }
            return results;
        }
    }

    public static abstract class PrimitiveState
    extends NextableState {
        abstract Set<MatchResult> matches(CharSequence var1, int var2, Function var3);

        public PrimitiveState(StateId stateId, NonTerminal nt, State.OrderingInfo orderingInfo) {
            super(stateId, nt, orderingInfo, true);
        }

        public static class MatchResult {
            public final int matchEnd;
            public final Function matchFunction;

            public MatchResult(int matchEnd, Function matchFunction) {
                this.matchEnd = matchEnd;
                this.matchFunction = matchFunction;
            }
        }
    }

    public static class NonTerminalState
    extends NextableState {
        public final NonTerminal child;
        public final boolean isLookahead;

        public NonTerminalState(StateId stateId, NonTerminal nt, State.OrderingInfo orderingInfo, NonTerminal child, boolean isLookahead) {
            super(stateId, nt, orderingInfo, true);
            nt.intermediaryStates.add(this);
            this.child = child;
            this.isLookahead = isLookahead;
        }
    }

    public static class EntryState
    extends NextableState {
        public EntryState(StateId stateId, NonTerminal nt, State.OrderingInfo orderingInfo) {
            super(stateId, nt, orderingInfo, false);
        }
    }

    public static abstract class NextableState
    extends State {
        public final Set<State> next = new HashSet<State>();

        NextableState(StateId stateId, NonTerminal nt, State.OrderingInfo orderingInfo, boolean intermediary) {
            super(stateId, nt, orderingInfo);
            if (intermediary) {
                nt.intermediaryStates.add(this);
            }
        }
    }

    public static class ExitState
    extends State {
        public ExitState(StateId stateId, NonTerminal nt, State.OrderingInfo orderingInfo) {
            super(stateId, nt, orderingInfo);
        }
    }

    public static abstract class State
    implements Comparable<State> {
        final StateId stateId;
        final NonTerminal nt;
        final OrderingInfo orderingInfo;

        public State(StateId stateId, NonTerminal nt, OrderingInfo orderingInfo) {
            this.stateId = stateId;
            this.nt = nt;
            this.orderingInfo = orderingInfo;
        }

        public Set<KList> runRule(Set<KList> input) {
            if (this instanceof ExitState) {
                return new HashSet<KList>(Arrays.asList(new KList(Arrays.asList(new Ambiguity("K", new ArrayList<Term>(input))))));
            }
            return input;
        }

        @Override
        public int compareTo(State that) {
            int x = this.orderingInfo.compareTo(that.orderingInfo);
            return x != 0 ? x : ((x = this.stateId.compareTo(that.stateId)) != 0 ? x : this.nt.compareTo(that.nt));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            if (!this.nt.equals(state.nt)) {
                return false;
            }
            return this.stateId.equals(state.stateId);
        }

        public int hashCode() {
            int result = this.stateId.hashCode();
            result = 31 * result + this.nt.hashCode();
            return result;
        }

        static class OrderingInfo
        implements Comparable<OrderingInfo> {
            int key;

            public OrderingInfo(int key) {
                this.key = key;
            }

            @Override
            public int compareTo(OrderingInfo that) {
                return Integer.compare(this.key, that.key);
            }
        }
    }

    public static class NonTerminal
    implements Comparable<NonTerminal> {
        public final NonTerminalId nonTerminalId;
        public final EntryState entryState;
        public final ExitState exitState;
        Set<NextableState> intermediaryStates = new HashSet<NextableState>();

        public NonTerminal(NonTerminalId nonTerminalId, StateId entryStateId, State.OrderingInfo entryOrderingInfo, StateId exitStateId, State.OrderingInfo exitOrderingInfo) {
            this.nonTerminalId = nonTerminalId;
            this.entryState = new EntryState(entryStateId, this, entryOrderingInfo);
            this.exitState = new ExitState(exitStateId, this, exitOrderingInfo);
        }

        @Override
        public int compareTo(NonTerminal that) {
            return this.nonTerminalId.compareTo(that.nonTerminalId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NonTerminal that = (NonTerminal)o;
            return this.nonTerminalId.equals(that.nonTerminalId);
        }

        public int hashCode() {
            return this.nonTerminalId.hashCode();
        }
    }

    public static class NonTerminalId
    implements Comparable<NonTerminalId> {
        String name;

        public NonTerminalId(String name) {
            this.name = name;
        }

        @Override
        public int compareTo(NonTerminalId that) {
            return this.name.compareTo(that.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NonTerminalId that = (NonTerminalId)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static class StateId
    implements Comparable<StateId> {
        String name;

        public StateId(String name) {
            this.name = name;
        }

        @Override
        public int compareTo(StateId that) {
            return this.name.compareTo(that.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StateId stateId = (StateId)o;
            return this.name.equals(stateId.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

