/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.parser.concrete2;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.kframework.kil.Ambiguity;
import org.kframework.kil.KList;
import org.kframework.kil.Term;
import org.kframework.parser.concrete2.Function;
import org.kframework.parser.concrete2.Grammar;
import org.kframework.parser.concrete2.NonTerminalCall;
import org.kframework.parser.concrete2.ParseState;
import org.kframework.parser.concrete2.StateCall;
import org.kframework.parser.concrete2.StateReturn;

public class Parser {
    private final ParseState s;

    public static void main(String[] args) {
        try {
            System.in.read();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Grammar.NonTerminalId ntistart = new Grammar.NonTerminalId("StartNT");
        Grammar.StateId stistart = new Grammar.StateId("StartState");
        Grammar.StateId stiend = new Grammar.StateId("EndState");
        Grammar.NonTerminal nt1 = new Grammar.NonTerminal(ntistart, stistart, new Grammar.State.OrderingInfo(0), stiend, new Grammar.State.OrderingInfo(100));
        Grammar.RegExState res1 = new Grammar.RegExState(new Grammar.StateId("RegExStid"), nt1, new Grammar.State.OrderingInfo(1), Pattern.compile("[a-zA-Z0-9]"));
        nt1.entryState.next.add(res1);
        nt1.entryState.next.add(nt1.exitState);
        res1.next.add(nt1.exitState);
        res1.next.add(res1);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 100000; ++i) {
            sb.append('a');
        }
        for (int j = 0; j < 10; ++j) {
            long start = Parser.getCpuTime();
            for (int i = 0; i < 1; ++i) {
                Term result = new Parser(new ParseState(sb.toString())).parse(nt1, 0);
            }
            long end = Parser.getCpuTime();
            System.out.println("Time: " + (double)(end - start) / 1000000.0);
        }
        try {
            System.in.read();
            System.in.read();
            System.in.read();
            System.in.read();
            System.in.read();
            System.in.read();
            System.in.read();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static long getCpuTime() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        return bean.isCurrentThreadCpuTimeSupported() ? bean.getCurrentThreadCpuTime() : 0L;
    }

    public Parser(ParseState parseState) {
        this.s = parseState;
    }

    public Term parse(Grammar.NonTerminal nt, int position) {
        Grammar.NonTerminal startNt = new Grammar.NonTerminal(new Grammar.NonTerminalId("<start>"), new Grammar.StateId("<start-entry>"), new Grammar.State.OrderingInfo(Integer.MIN_VALUE), new Grammar.StateId("<start-exit>"), new Grammar.State.OrderingInfo(Integer.MAX_VALUE));
        Grammar.NonTerminalState state = new Grammar.NonTerminalState(new Grammar.StateId("<start>"), startNt, new Grammar.State.OrderingInfo(0x7FFFFFFE), nt, true);
        this.activateNtCall(this.s.getStateCall(new StateCall.Key(this.s.getNtCall(new NonTerminalCall.Key(nt, position)), position, state)));
        while (this.s.stateReturnWorkLists.top() != null) {
            StateReturn stateReturn = null;
            while ((stateReturn = this.s.stateReturnWorkLists.top().dequeue()) != null) {
                this.stateReturn(stateReturn);
            }
            this.s.stateReturnWorkLists.pop();
        }
        Ambiguity result = new Ambiguity("K", new ArrayList<Term>());
        for (StateReturn stateReturn : this.s.getNtCall((NonTerminalCall.Key)new NonTerminalCall.Key((Grammar.NonTerminal)nt, (int)0)).exitStateReturns) {
            if (stateReturn.key.stateEnd != this.s.input.length()) continue;
            for (KList klist : stateReturn.postRuleFunction.applyToNull()) {
                result.getContents().add(klist);
            }
        }
        return result;
    }

    private void unknownStateType() {
        assert (false) : "Unknown state type";
    }

    public void stateReturn(StateReturn stateReturn) {
        stateReturn.postRuleFunction.addFactoredAndRunRule(stateReturn.preRuleFunction, stateReturn);
        Grammar.State state = stateReturn.key.stateCall.key.state;
        if (state instanceof Grammar.ExitState) {
            for (StateCall stateCall : stateReturn.key.stateCall.key.ntCall.callers) {
                int stateEnd = ((Grammar.NonTerminalState)stateCall.key.state).isLookahead ? stateCall.key.stateBegin : stateReturn.key.stateEnd;
                this.addPreRuleFunction(new StateReturn.Key(stateCall, stateEnd), stateCall.function, stateReturn.postRuleFunction);
            }
        } else if (state instanceof Grammar.NextableState) {
            for (Grammar.State nextState : ((Grammar.NextableState)state).next) {
                StateCall stateCall = this.activateStateCall(new StateCall.Key(stateReturn.key.stateCall.key.ntCall, stateReturn.key.stateEnd, nextState), stateReturn.postRuleFunction);
                if (nextState instanceof Grammar.ExitState) {
                    this.addPreRuleFunction(new StateReturn.Key(stateCall, stateCall.key.stateBegin), stateCall.function, Function.identity());
                    continue;
                }
                if (nextState instanceof Grammar.PrimitiveState) {
                    for (Grammar.PrimitiveState.MatchResult matchResult : ((Grammar.PrimitiveState)nextState).matches(this.s.input, stateCall.key.stateBegin, stateCall.function)) {
                        this.addPreRuleFunction(new StateReturn.Key(stateCall, matchResult.matchEnd), stateCall.function, matchResult.matchFunction);
                    }
                    continue;
                }
                if (nextState instanceof Grammar.NonTerminalState) {
                    this.activateNtCall(stateCall);
                    continue;
                }
                this.unknownStateType();
            }
        } else {
            this.unknownStateType();
        }
    }

    void activateNtCall(StateCall stateCall) {
        if (((Grammar.NonTerminalState)stateCall.key.state).isLookahead) {
            this.s.stateReturnWorkLists.push();
        }
        NonTerminalCall ntCall = this.s.getNtCall(new NonTerminalCall.Key(((Grammar.NonTerminalState)stateCall.key.state).child, stateCall.key.stateBegin));
        ntCall.callers.add(stateCall);
        StateCall entryStateCall = this.activateStateCall(new StateCall.Key(ntCall, ntCall.key.ntBegin, ntCall.key.nt.entryState), Function.identity());
        this.addPreRuleFunction(new StateReturn.Key(entryStateCall, ntCall.key.ntBegin), Function.identity(), Function.identity());
    }

    StateCall activateStateCall(StateCall.Key key, Function function) {
        StateCall stateCall = this.s.getStateCall(key);
        stateCall.workList = this.s.stateReturnWorkLists.top();
        stateCall.function.addFunction(function);
        return stateCall;
    }

    void addPreRuleFunction(StateReturn.Key key, Function sibling, Function child) {
        StateReturn stateReturn = this.s.getStateReturn(key);
        stateReturn.key.stateCall.key.ntCall.stateReturns.add(stateReturn);
        if (stateReturn.key.stateCall.key.state instanceof Grammar.ExitState) {
            stateReturn.key.stateCall.key.ntCall.exitStateReturns.add(stateReturn);
        }
        if (stateReturn.preRuleFunction.addFunctionComposition(sibling, child)) {
            stateReturn.key.stateCall.workList.enqueue(stateReturn);
        }
    }
}

