/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.parser.generator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kframework.kil.ASTNode;
import org.kframework.kil.DefinitionItem;
import org.kframework.kil.Module;
import org.kframework.kil.Require;
import org.kframework.kil.loader.Context;
import org.kframework.parser.basic.Basic;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.file.FileUtil;
import org.kframework.utils.file.KPaths;
import org.kframework.utils.general.GlobalSettings;

public class BasicParser {
    private List<DefinitionItem> moduleItems;
    private Map<String, Module> modulesMap;
    private List<String> filePaths;
    private File mainFile;
    private String mainModule;
    private boolean autoinclude;
    private static final String missingFileMsg = "Could not find 'required' file: ";
    private String autoincludeFileName;

    public BasicParser(boolean autoinclude) {
        this.autoinclude = autoinclude;
        this.autoincludeFileName = GlobalSettings.javaBackend ? "autoinclude-java.k" : "autoinclude.k";
    }

    public void slurp(String fileName, Context context) {
        this.moduleItems = new ArrayList<DefinitionItem>();
        this.modulesMap = new HashMap<String, Module>();
        this.filePaths = new ArrayList<String>();
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, missingFileMsg + fileName + " given at console.", "", ""));
            }
            this.slurp2(file, context);
            if (this.autoinclude) {
                List<DefinitionItem> tempmi = this.moduleItems;
                this.moduleItems = new ArrayList<DefinitionItem>();
                file = this.buildCanonicalPath(this.autoincludeFileName, new File(fileName));
                if (file == null) {
                    GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, missingFileMsg + fileName + " autoimported for every definition ", fileName, ""));
                }
                this.slurp2(file, context);
                this.moduleItems.addAll(tempmi);
            }
            this.setMainFile(file);
            context.finalizeRequirements();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File buildCanonicalPath(String fileName, File parentFile) throws IOException {
        File file = new File(parentFile.getCanonicalFile().getParent() + "/" + fileName);
        if (file.exists()) {
            return file;
        }
        file = new File(KPaths.getKBase(false) + "/include/" + fileName);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private void slurp2(File file, Context context) throws IOException {
        String canonicalPath = file.getCanonicalPath();
        if (!this.filePaths.contains(canonicalPath)) {
            this.filePaths.add(canonicalPath);
            if (GlobalSettings.verbose) {
                System.out.println("Including file: " + file.getAbsolutePath());
            }
            List<DefinitionItem> defItemList = Basic.parse(file.getAbsolutePath(), FileUtil.getFileContent(file.getAbsolutePath()), context);
            for (ASTNode aSTNode : defItemList) {
                if (!(aSTNode instanceof Require)) continue;
                Require req = (Require)aSTNode;
                File newFile = this.buildCanonicalPath(req.getValue(), file);
                if (newFile == null) {
                    GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, missingFileMsg + req.getValue(), req.getFilename(), req.getLocation()));
                }
                this.slurp2(newFile, context);
                context.addFileRequirement(newFile.getCanonicalPath(), file.getCanonicalPath());
            }
            boolean predefined = file.getCanonicalPath().startsWith(KPaths.getKBase(false) + File.separator + "include");
            if (!predefined) {
                context.addFileRequirement(this.buildCanonicalPath(this.autoincludeFileName, file).getCanonicalPath(), file.getCanonicalPath());
            }
            for (DefinitionItem di : defItemList) {
                if (predefined) {
                    di.setPredefined(true);
                }
                this.moduleItems.add(di);
                if (!(di instanceof Module)) continue;
                Module m = (Module)di;
                this.modulesMap.put(m.getName(), m);
            }
        }
    }

    public void setMainFile(File mainFile) {
        this.mainFile = mainFile;
    }

    public File getMainFile() {
        return this.mainFile;
    }

    public void setMainModule(String mainModule) {
        this.mainModule = mainModule;
    }

    public String getMainModule() {
        return this.mainModule;
    }

    public List<DefinitionItem> getModuleItems() {
        return this.moduleItems;
    }

    public void setModuleItems(List<DefinitionItem> moduleItems) {
        this.moduleItems = moduleItems;
    }

    public Map<String, Module> getModulesMap() {
        return this.modulesMap;
    }

    public void setModulesMap(Map<String, Module> modulesMap) {
        this.modulesMap = modulesMap;
    }
}

