/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.parser.generator;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.Definition;
import org.kframework.kil.Import;
import org.kframework.kil.Module;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicVisitor;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class CollectIncludedModulesVisitor
extends BasicVisitor {
    public Set<String> modNames = new HashSet<String>();
    private String startModuleName;

    public CollectIncludedModulesVisitor(String startModuleName, Context context) {
        super(context);
        this.startModuleName = startModuleName;
    }

    @Override
    public void visit(Definition def) {
        LinkedList<String> synQue = new LinkedList<String>();
        synQue.add(this.startModuleName);
        while (!synQue.isEmpty()) {
            String mname = (String)synQue.remove(0);
            if (this.modNames.contains(mname)) continue;
            this.modNames.add(mname);
            Module m = def.getModulesMap().get(mname);
            for (ModuleItem s : m.getItems()) {
                if (!(s instanceof Import)) continue;
                Import imp = (Import)s;
                String mname2 = imp.getName();
                Module mm = def.getModulesMap().get(mname2);
                if (mname2.startsWith("#")) continue;
                if (mm != null) {
                    synQue.add(mm.getName());
                    continue;
                }
                if (MetaK.isKModule(mname2)) continue;
                String msg = "Could not find module: " + mname2 + " imported from: " + m.getName();
                GlobalSettings.kem.register(new KException(KException.ExceptionType.WARNING, KException.KExceptionGroup.PARSER, msg, imp.getFilename(), imp.getLocation()));
            }
        }
    }
}

